/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.keystrokes;

import java.util.List;

import com.google.common.collect.ImmutableList;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.ButtonWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.Element;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.ElementListWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.VanillaButtonWidget;
import io.github.axolotlclient.modules.hud.gui.hud.KeystrokeHud;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.unmapped.C_1331819;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_8105098;

@Environment(EnvType.CLIENT)
public class KeyBindsList extends ElementListWidget<KeyBindsList.Entry> {
	final KeystrokesScreen keyBindsScreen;
	private int maxNameWidth;

	public KeyBindsList(KeystrokesScreen keyBindsScreen) {
		super(C_8105098.m_0408063(), keyBindsScreen.f_5465691, keyBindsScreen.f_3080061, 33, keyBindsScreen.f_3080061 - 33, 24);
		this.keyBindsScreen = keyBindsScreen;

		reload();
	}

	public void reload() {
		clearEntries();
		for (KeystrokeHud.Keystroke keyMapping : keyBindsScreen.hud.keystrokes) {

			String component = C_3390001.m_2053009(keyMapping.getKey().getName());
			int i = client.f_0426313.m_0040387(component);
			if (i > this.maxNameWidth) {
				this.maxNameWidth = i;
			}

			this.addEntry(new KeyEntry(keyMapping, component));
		}

		addEntry(new SpacerEntry());
		addEntry(new NewEntry());
	}

	@Override
	protected int getScrollbarPositionX() {
		return getRowLeft() + getRowWidth() + 10;
	}

	@Override
	public int getRowWidth() {
		return 340;
	}

	@Environment(EnvType.CLIENT)
	public abstract static class Entry extends ElementListWidget.Entry<io.github.axolotlclient.modules.hud.gui.keystrokes.KeyBindsList.Entry> {

	}

	public static class SpacerEntry extends io.github.axolotlclient.modules.hud.gui.keystrokes.KeyBindsList.Entry {

		@Override
		public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {

		}

		@Override
		public List<? extends Element> children() {
			return List.of();
		}
	}

	private static final String CONFIGURE_BUTTON_TITLE = C_3390001.m_2053009("keystrokes.stroke.configure");

	@Environment(EnvType.CLIENT)
	public class KeyEntry extends io.github.axolotlclient.modules.hud.gui.keystrokes.KeyBindsList.Entry {
		private static final String REMOVE_BUTTON_TITLE = C_3390001.m_2053009("keystrokes.stroke.remove");
		private final KeystrokeHud.Keystroke key;
		private final String name;
		private final ButtonWidget configureButton, removeButton;

		KeyEntry(final KeystrokeHud.Keystroke key, final String name) {
			this.key = key;
			this.name = C_1331819.m_9293214(key.getKey().getKeyCode());
			this.configureButton = new VanillaButtonWidget(0, 0, 75, 20, CONFIGURE_BUTTON_TITLE, button -> client.m_6408915(new ConfigureKeyBindScreen(keyBindsScreen, keyBindsScreen.hud, key, false)));
			this.removeButton = new VanillaButtonWidget(0, 0, 50, 20, REMOVE_BUTTON_TITLE, b -> {
				removeEntry(this);
				keyBindsScreen.removeKey(key);
				setScrollAmount(getScrollAmount());
			});
		}

		@Override
		public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
			int i = KeyBindsList.this.getScrollbarPositionX() - removeButton.getWidth() - 10;
			int j = top - 2;
			this.removeButton.setPosition(i, j);
			this.removeButton.render(mouseX, mouseY, partialTick);
			int k = i - this.configureButton.getWidth();
			this.configureButton.setPosition(k, j);
			this.configureButton.render(mouseX, mouseY, partialTick);
			C_3754158.m_8373640();
			var rect = key.getRenderPosition();
			float scale = Math.min((float) height / rect.height(), (float) 100 / rect.width());
			C_3754158.m_3172490(left, top, 0);
			C_3754158.m_4552250(scale, scale, 1);
			C_3754158.m_3172490(-rect.x(), -rect.y(), 0);
			key.render();
			C_3754158.m_2041265();
			client.f_0426313.m_1950885(name, left + width / 2f - client.f_0426313.m_0040387(name) / 2f, top + height / 2f - 9 / 2f, Colors.GRAY.toInt());
		}

		@Override
		public List<? extends Element> children() {
			return ImmutableList.of(this.configureButton, removeButton);
		}
	}

	public class NewEntry extends io.github.axolotlclient.modules.hud.gui.keystrokes.KeyBindsList.Entry {

		private final ButtonWidget addButton, addSpecialButton;
		private final KeystrokeHud.Keystroke key = keyBindsScreen.hud.newStroke();

		public NewEntry() {
			this.addButton = new VanillaButtonWidget(0, 0, 150, 20, C_3390001.m_2053009("keystrokes.stroke.add"), button -> client.m_6408915(new ConfigureKeyBindScreen(keyBindsScreen, keyBindsScreen.hud, key, true)));
			this.addSpecialButton = new VanillaButtonWidget(0, 0, 150, 20, C_3390001.m_2053009("keystrokes.stroke.add.special"),
				button -> client.m_6408915(new AddSpecialKeystrokeScreen(keyBindsScreen, keyBindsScreen.hud)));
		}

		@Override
		public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
			int i = KeyBindsList.this.getScrollbarPositionX() - width / 2 - 10 + 4;
			int j = top - 2;
			this.addButton.setPosition(i, j);
			this.addButton.render(mouseX, mouseY, partialTick);
			int k = i - addButton.getWidth() - 8;
			this.addSpecialButton.setPosition(k, j);
			this.addSpecialButton.render(mouseX, mouseY, partialTick);
		}

		@Override
		public List<? extends Element> children() {
			return List.of(addSpecialButton, addButton);
		}
	}
}
