/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.keystrokes;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3754158;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.bridge.impl.AxoRenderContextImpl;
import io.github.axolotlclient.modules.hud.HudEditScreen;
import io.github.axolotlclient.modules.hud.HudManager;
import io.github.axolotlclient.modules.hud.gui.hud.KeystrokeHud;
import io.github.axolotlclient.modules.hud.snapping.SnappingHelper;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.modules.hud.util.Rectangle;
import io.github.axolotlclient.util.ClientColors;
import org.lwjgl.input.Keyboard;

public class KeystrokePositioningScreen extends C_3020744 {
	private static final String title = C_3390001.m_2053009("keystrokes.stroke.move");
	private final C_3020744 parent;
	private final KeystrokeHud hud;
	private KeystrokeHud.Keystroke focused;
	private final KeystrokeHud.Keystroke editing;

	public KeystrokePositioningScreen(C_3020744 parent, KeystrokeHud hud, KeystrokeHud.Keystroke focused) {
		super();
		this.parent = parent;
		this.hud = hud;
		if (hud.keystrokes == null) {
			hud.setKeystrokes();
		}
		this.editing = focused;
		mouseDown = false;
	}

	public KeystrokePositioningScreen(C_3020744 parent, KeystrokeHud hud) {
		this(parent, hud, null);
	}

	private DrawPosition offset = null;
	private boolean mouseDown;
	private SnappingHelper snap;

	@Override
	protected void m_7971793(C_2348249 buttonWidget) {
		if (buttonWidget.f_5920996 == 0) {
			closeScreen();
		} else if (buttonWidget.f_5920996 == 1) {
			HudEditScreen.toggleSnapping();
			buttonWidget.f_4865617 = C_3390001.m_2053009("hud.snapping") + ": " +
				C_3390001.m_2053009(HudEditScreen.isSnappingEnabled() ? "options.on" : "options.off");
			AxolotlClient.getInstance().saveConfig();
		}
	}

	@Override
	public void m_3593494() {
		f_2213969.add(new C_2348249(0, f_5465691 / 2 - 75, f_3080061 - 50 + 22, 150, 20, C_3390001.m_2053009("gui.back")));
		f_2213969.add(new C_2348249(1, f_5465691 / 2 - 50, f_3080061 - 50, 100, 20, C_3390001.m_2053009("hud.snapping") + ": "
			+ (C_3390001.m_2053009(HudEditScreen.isSnappingEnabled() ? "options.on" : "options.off"))));
	}

	private float partialTick;

	@Override
	public void m_7817195() {
		C_3754158.m_8373640();
		C_3754158.m_3172490(0, 0, -300);
		super.m_7817195();
		HudManager.getInstance().renderPlaceholder(AxoRenderContextImpl.getInstance(), partialTick);
		C_3754158.m_2041265();
		m_9889399(0, 0, this.f_5465691, this.f_3080061, -1072689136, -804253680);
	}

	@Override
	public void m_7261014(int mouseX, int mouseY, float partialTick) {
		this.partialTick = partialTick;
		m_7817195();
		super.m_7261014(mouseX, mouseY, partialTick);
		if (editing != null) {
			drawStroke(mouseX, mouseY, editing);
		} else {
			hud.keystrokes.forEach(s -> drawStroke(mouseX, mouseY, s));
		}
		if (mouseDown && snap != null) {
			snap.renderSnaps();
		}
	}

	private void drawStroke(int mouseX, int mouseY, KeystrokeHud.Keystroke s) {
		var rect = getScaledRenderPos(s);
		if (rect.isMouseOver(mouseX, mouseY)) {
			DrawUtil.fillRect(rect, ClientColors.SELECTOR_BLUE.withAlpha(100));
		} else {
			DrawUtil.fillRect(rect, ClientColors.WHITE.withAlpha(50));
		}
		C_3754158.m_8373640();
		C_3754158.m_4552250(hud.getScale(), hud.getScale(), 1);
		s.render();
		C_3754158.m_2041265();
		DrawUtil.outlineRect(rect, Colors.BLACK);
	}

	@Override
	public void m_7362766(int mouseX, int mouseY, int button) {
		super.m_7362766(mouseX, mouseY, button);
		if (button == 0) {
			Optional<KeystrokeHud.Keystroke> entry = Optional.empty();
			Optional<Rectangle> pos = Optional.empty();
			if (editing == null) {
				for (KeystrokeHud.Keystroke k : hud.keystrokes) {
					pos = Optional.of(getScaledRenderPos(k));
					if (pos.get().isMouseOver(mouseX, mouseY)) {
						entry = Optional.of(k);
						break;
					}
				}
			} else {
				pos = Optional.of(getScaledRenderPos(editing));
				if (pos.get().isMouseOver(mouseX, mouseY)) {
					entry = Optional.of(editing);
				}
			}
			if (entry.isPresent()) {
				focused = entry.get();
				mouseDown = true;
				var rect = pos.get();
				offset = new DrawPosition(mouseX - rect.x(),
					mouseY - rect.y());
				updateSnapState();
			} else {
				focused = null;
			}
		}
	}


	public void closeScreen() {
		f_7153641.m_6408915(parent);
		hud.saveKeystrokes();
	}

	@Override
	protected void m_6992336(char c, int code) {
		if (code == Keyboard.KEY_ESCAPE) {
			closeScreen();
		}
	}

	@Override
	public void m_5308748(int mouseX, int mouseY, int button) {
		if (focused != null) {
			hud.saveKeystrokes();
		}
		snap = null;
		mouseDown = false;
		focused = null;
		super.m_5308748(mouseX, mouseY, button);
	}

	@Override
	public void m_5535405(int mouseX, int mouseY, int button, long mouseLastClicked) {
		if (focused != null && mouseDown) {
			focused.setX(Math.round((mouseX - offset.x()) / hud.getScale()));
			focused.setY(Math.round((mouseY - offset.y()) / hud.getScale()));
			if (snap != null) {
				Integer snapX, snapY;
				var rect = getScaledRenderPos(focused);
				snap.setCurrent(rect);
				if ((snapX = snap.getCurrentXSnap()) != null) {
					focused.setX((int) (snapX / hud.getScale()));
				}
				if ((snapY = snap.getCurrentYSnap()) != null) {
					focused.setY(Math.round(snapY / hud.getScale()));
				}
			}
		}
	}

	private Rectangle getScaledRenderPos(KeystrokeHud.Keystroke stroke) {
		return stroke.getRenderPosition().scale(hud.getScale());
	}

	private List<Rectangle> getAllBounds() {
		return Stream.concat(HudManager.getInstance().getAllBounds().stream(), hud.keystrokes.stream().map(this::getScaledRenderPos)).toList();
	}

	private void updateSnapState() {
		if (HudEditScreen.isSnappingEnabled() && focused != null) {
			snap = new SnappingHelper(getAllBounds(), getScaledRenderPos(focused));
		} else if (snap != null) {
			snap = null;
		}
	}
}
