/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.keystrokes;

import java.util.List;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.VanillaButtonWidget;
import io.github.axolotlclient.modules.hud.gui.hud.KeystrokeHud;
import org.lwjgl.input.Keyboard;

public class KeystrokesScreen extends io.github.axolotlclient.AxolotlClientConfig.impl.ui.Screen {

	private final List<KeystrokeHud.Keystroke> keys;
	public final KeystrokeHud hud;
	private final C_3020744 screen;

	public KeystrokesScreen(KeystrokeHud hud, C_3020744 screen) {
		super(C_3390001.m_2053009("keystrokes.keys"));
		if (hud.keystrokes == null) {
			hud.setKeystrokes();
		}
		this.keys = hud.keystrokes;
		this.hud = hud;
		this.screen = screen;
	}

	@Override
	public void m_7261014(int mouseX, int mouseY, float delta) {
		super.m_7261014(mouseX, mouseY, delta);
		m_2717572(f_2020658, getTitle(), f_5465691 / 2, 33 / 2 - f_2020658.f_6725889 / 2, -1);
	}

	@Override
	public void m_3593494() {

		var keyBindsList = addDrawableChild(new KeyBindsList(this));
		addDrawableChild(new VanillaButtonWidget(f_5465691 / 2 - 150 - 4, f_3080061 - 33 / 2 - 10, 150, 20, C_3390001.m_2053009("controls.resetAll"), button -> {
			keys.clear();
			hud.setDefaultKeystrokes();
			keyBindsList.reload();
			hud.saveKeystrokes();
		}));
		addDrawableChild(new VanillaButtonWidget(f_5465691 / 2 + 4, f_3080061 - 33 / 2 - 10, 150, 20, C_3390001.m_2053009("gui.done"), button -> this.closeScreen()));

	}


	public void closeScreen() {
		this.f_7153641.m_6408915(this.screen);
		hud.saveKeystrokes();
	}

	@Override
	public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
		if (keyCode == Keyboard.KEY_ESCAPE) {
			closeScreen();
			return true;
		}
		return super.keyPressed(keyCode, scanCode, modifiers);
	}

	public void removeKey(KeystrokeHud.Keystroke key) {
		keys.remove(key);
	}
}
