/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.util;

import lombok.experimental.UtilityClass;
import net.minecraft.unmapped.C_1945050;
import net.minecraft.unmapped.C_2454309;
import net.minecraft.unmapped.C_2899740;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_4461663;
import net.minecraft.unmapped.C_5786166;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8373595;

/**
 * This implementation of Hud modules is based on KronHUD.
 * <a href="https://github.com/DarkKronicle/KronHUD">Github Link.</a>
 *
 * <p>License: GPL-3.0</p>
 */

@UtilityClass
public class ItemUtil {
	// The scaling stuff wasn't a problem on 1.8.9 so no need to create more complicated stuff

	public static void renderGuiItemModel(C_2454309 stack, int x, int y) {
		if (stack != null && stack.m_2410511() != null) {
			C_2899740.m_1560027();
			C_3754158.m_8373640();
			C_8105098.m_0408063().m_9172989().m_5348538(stack, x, y);
			C_3754158.m_2041265();
			C_2899740.m_8989115();
		}
	}

	public static void renderGuiItemOverlay(C_3831727 renderer, C_2454309 stack, int x, int y, String countLabel,
											int textColor, boolean shadow) {
		C_2899740.m_1560027();
		C_3754158.m_8373640();
		C_3754158.m_3323122(textColor >> 24 & 0xff, textColor >> 16 & 0xff, textColor >> 8 & 0xff, textColor & 0xff);
		if (stack != null) {
			if (stack.f_1354050 != 1 || countLabel != null) {
				String string = countLabel == null ? String.valueOf(stack.f_1354050) : countLabel;
				if (countLabel == null && stack.f_1354050 < 1) {
					string = C_1945050.f_9213701 + String.valueOf(stack.f_1354050);
				}

				C_3754158.m_4272493();
				C_3754158.m_7027522();
				C_3754158.m_5313301();
				renderer.m_4413321(string, (float) (x + 19 - 2 - renderer.m_0040387(string)), (float) (y + 6 + 3),
					16777215, shadow);
				C_3754158.m_3333397();
				C_3754158.m_9078814();
			}

			if (stack.m_3708793()) {
				int i = (int) Math.round(13.0 - (double) stack.m_2360020() * 13.0 / (double) stack.m_3453584());
				int j = (int) Math.round(255.0 - (double) stack.m_2360020() * 255.0 / (double) stack.m_3453584());
				C_3754158.m_4272493();
				C_3754158.m_7027522();
				C_3754158.m_2090124();
				C_3754158.m_6191982();
				C_3754158.m_5313301();
				C_5786166 tessellator = C_5786166.m_2065116();
				C_8373595 bufferBuilder = tessellator.m_1454391();
				renderGuiQuad(bufferBuilder, x + 2, y + 13, 13, 2, 0, 0, 0, 255);
				renderGuiQuad(bufferBuilder, x + 2, y + 13, 12, 1, (255 - j) / 4, 64, 0, 255);
				renderGuiQuad(bufferBuilder, x + 2, y + 13, i, 1, 255 - j, j, 0, 255);
				C_3754158.m_9671730();
				C_3754158.m_2754767();
				C_3754158.m_7547086();
				C_3754158.m_3333397();
				C_3754158.m_9078814();
			}
		}

		C_2899740.m_8989115();
		C_3754158.m_2041265();
		C_3754158.m_3323122(1, 1, 1, 1);
	}

	private static void renderGuiQuad(C_8373595 buffer, int x, int y, int width, int height, int red, int green,
									  int blue, int alpha) {
		buffer.m_0421390(7, C_4461663.f_8459667);
		buffer.m_3299851(x, y, 0.0).m_9724942(red, green, blue, alpha).m_4365807();
		buffer.m_3299851(x, y + height, 0.0).m_9724942(red, green, blue, alpha).m_4365807();
		buffer.m_3299851(x + width, y + height, 0.0).m_9724942(red, green, blue, alpha).m_4365807();
		buffer.m_3299851(x + width, y, 0.0).m_9724942(red, green, blue, alpha).m_4365807();
		C_5786166.m_2065116().m_8222644();
	}
}
