/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.screenshotUtils;

import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_2925725;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_8105098;

public class DownloadImageScreen extends C_3020744 {
	private static final C_0561170 SPRITE = new C_0561170("axolotlclient", "textures/gui/sprites/go.png");

	private final C_3020744 parent;

	private final String title;
	private C_2925725 urlBox;

	public DownloadImageScreen(C_3020744 parent) {
		super();
		this.title = C_3390001.m_2053009("viewScreenshot");
		this.parent = parent;
	}

	@Override
	public void m_7261014(int mouseX, int mouseY, float delta) {
		m_7817195();
		urlBox.m_1620442();
		super.m_7261014(mouseX, mouseY, delta);
		m_2717572(f_2020658, title, f_5465691 / 2, 33 / 2 - f_2020658.f_6725889 / 2, -1);
	}

	@Override
	public void m_3593494() {
		urlBox = new C_2925725(0, f_2020658, f_5465691 / 2 - 100, f_3080061 / 2 - 10, 200, 20) {
			@Override
			public void m_1620442() {
				super.m_1620442();

				if (m_4862541().isEmpty()) {
					m_6649515(C_8105098.m_0408063().f_0426313, C_3390001.m_2053009("pasteURL"), f_2565579 + 3, f_8286097 + 6, -8355712);
				}
			}
		};
		urlBox.m_1954651(63);
		f_2213969.add(new C_2348249(1, f_5465691 / 2 + 100 + 4, f_3080061 / 2 - 10, 20, 20, C_3390001.m_2053009("download")) {
			@Override
			public void m_5350167(C_8105098 client, int mouseX, int mouseY) {
				client.m_1218956().m_5325521(f_1377664);
				C_3754158.m_3323122(1.0F, 1.0F, 1.0F, 1.0F);
				this.f_8690685 = mouseX >= this.f_3923091 && mouseY >= this.f_8532347 && mouseX < this.f_3923091 + this.f_9527567 && mouseY < this.f_8532347 + this.f_7845401;
				int i = this.m_8274414(this.f_8690685);
				C_3754158.m_9671730();
				C_3754158.m_0833259(770, 771, 1, 0);
				C_3754158.m_2076358(770, 771);
				this.m_4354119(this.f_3923091, this.f_8532347, 0, 46 + i * 20, this.f_9527567 / 2, this.f_7845401);
				this.m_4354119(this.f_3923091 + this.f_9527567 / 2, this.f_8532347, 200 - this.f_9527567 / 2, 46 + i * 20, this.f_9527567 / 2, this.f_7845401);
				C_8105098.m_0408063().m_1218956().m_5325521(SPRITE);
				m_5935491(f_3923091, f_8532347, 0, 0, this.m_8567079(), this.f_7845401, this.m_8567079(), this.f_7845401);
			}
		});

		f_2213969.add(new C_2348249(2, f_5465691 / 2 - 75, f_3080061 - 33 / 2 - 10, 150, 20, C_3390001.m_2053009("gui.back")));
	}

	@Override
	protected void m_7971793(C_2348249 buttonWidget) {
		if (buttonWidget.f_5920996 == 1) {
			String url = urlBox.m_4862541().trim();
			if (url.isEmpty()) {
				return;
			}
			f_7153641.m_6408915(ImageScreen.create(this, ImageShare.getInstance().downloadImage(url), true));
		} else if (buttonWidget.f_5920996 == 2) {
			f_7153641.m_6408915(parent);
		}
	}

	@Override
	protected void m_6992336(char character, int code) {
		super.m_6992336(character, code);
		urlBox.m_1973329(character, code);
	}

	@Override
	protected void m_7362766(int mouseX, int mouseY, int button) {
		super.m_7362766(mouseX, mouseY, button);
		urlBox.m_1129375(mouseX, mouseY, button);
	}

	@Override
	public void m_2450377() {
		urlBox.m_0296611();
	}
}
