/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.screenshotUtils;

import java.util.concurrent.CompletableFuture;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_4461663;
import net.minecraft.unmapped.C_4976084;
import net.minecraft.unmapped.C_5786166;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8373595;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.util.Util;
import org.lwjgl.opengl.GL11;

public class LoadingImageScreen extends C_3020744 {

	private static final int bgColor = Colors.DARK_GRAY.toInt();
	private static final int accent = Colors.GRAY.withBrightness(0.5f).withAlpha(128).toInt();

	private final C_3020744 parent;
	private final CompletableFuture<Void> future;
	private final boolean freeOnClose;
	private final float loadStart = C_8105098.m_6224581();
	private final String title;

	LoadingImageScreen(C_3020744 parent, CompletableFuture<Void> future, boolean freeOnClose) {
		super();
		this.title = C_3390001.m_2053009("gallery.image.loading.title");
		this.parent = parent;
		this.future = future;
		this.freeOnClose = freeOnClose;
	}

	@Override
	public void m_7261014(int mouseX, int mouseY, float delta) {
		m_7817195();
		super.m_7261014(mouseX, mouseY, delta);
		m_2717572(f_2020658, title, f_5465691 / 2, 33 / 2 - f_2020658.f_6725889 / 2, -1);
	}

	@Override
	public void m_3593494() {

		int buttonWidth = 75;
		int imageWidth = f_5465691 - 20 - buttonWidth - 4;
		int imageHeight = f_3080061 - 33 * 2;

		f_2213969.add(new LoadingWidget(imageWidth, imageHeight).setPosition(10, 36));
		f_2213969.add(new LoadingWidget(buttonWidth, 20).setPosition(10 + imageWidth + 4, 36));
		f_2213969.add(new LoadingWidget(buttonWidth, 20).setPosition(10 + imageWidth + 4, 36 + 20 + 4));

		f_2213969.add(new C_2348249(0, f_5465691 / 2 - 75, f_3080061 - 33 / 2 - 10, 150, 20, C_3390001.m_2053009("gui.back")));
	}

	@Override
	protected void m_7971793(C_2348249 buttonWidget) {
		if (buttonWidget.f_5920996 == 0) {
			if (freeOnClose) {
				future.cancel(false);
			}
			f_7153641.m_6408915(parent);
		}
	}

	private void drawHorizontalGradient(int x1, int y1, int y2, int x2) {
		C_8373595 consumer = C_5786166.m_2065116().m_1454391();
		consumer.m_0421390(GL11.GL_QUADS, C_4461663.f_8459667);
		consumer.m_3299851(x1, y1, 0).m_9724942(bgColor >> 16 & 255, bgColor >> 8 & 255, bgColor & 255, bgColor >> 24 & 255);
		consumer.m_3299851(x1, y2, 0).m_9724942(bgColor >> 16 & 255, bgColor >> 8 & 255, bgColor & 255, bgColor >> 24 & 255);
		consumer.m_3299851(x2, y2, 0).m_9724942(accent >> 16 & 255, accent >> 8 & 255, accent & 255, accent >> 24 & 255);
		consumer.m_3299851(x2, y1, 0).m_9724942(accent >> 16 & 255, accent >> 8 & 255, accent & 255, accent >> 24 & 255);
		C_5786166.m_2065116().m_8222644();
	}

	private double easeInOutCubic(double x) {
		return x < 0.5 ? 4 * x * x * x : 1 - Math.pow(-2 * x + 2, 3) / 2;
	}

	private int lerp(float delta, int start, int end) {
		return (int) C_4976084.m_7164829(Util.lerp(delta, start, end), start, end);
	}

	private class LoadingWidget extends C_2348249 {

		public LoadingWidget(int width, int height) {
			super(99, 0, 0, width, height, "");
			f_3831222 = false;
		}

		@Override
		public void m_5350167(C_8105098 client, int mouseX, int mouseY) {
			m_7865719(f_3923091, f_8532347, f_3923091 + m_8567079(), f_8532347 + getHeight(), bgColor);
			drawHorizontalGradient(f_3923091, f_8532347, f_8532347 + getHeight(), lerp((float) easeInOutCubic((C_8105098.m_6224581() - loadStart) % 1000f / 1000f), f_3923091, f_3923091 + m_8567079()));
		}

		private int getHeight() {
			return f_7845401;
		}

		public LoadingWidget setPosition(int x, int y) {
			this.f_3923091 = x;
			this.f_8532347 = y;
			return this;
		}
	}
}
