/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.sky;

import com.google.gson.JsonObject;
import io.github.axolotlclient.util.Util;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_4461663;
import net.minecraft.unmapped.C_5786166;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8373595;

public class MCPSkyboxInstance extends SkyboxInstance {

	public MCPSkyboxInstance(JsonObject json) {
		super(json);
		this.textures[0] = new C_0561170(json.get("source").getAsString());
		try {
			this.fade[0] = convertToTicks(json.get("startFadeIn").getAsInt());
			this.fade[1] = convertToTicks(json.get("endFadeIn").getAsInt());
			this.fade[3] = convertToTicks(json.get("endFadeOut").getAsInt());
		} catch (Exception e) {
			this.alwaysOn = true;
		}
		try {
			this.fade[2] = convertToTicks(json.get("startFadeOut").getAsInt());
		} catch (Exception ignored) {
			this.fade[2] = Util.getTicksBetween(Util.getTicksBetween(fade[0], fade[1]), fade[3]);
		}
		try {
			this.rotate = json.get("rotate").getAsBoolean();
			if (rotate) {
				this.rotationSpeed = json.get("speed").getAsFloat();
			}
		} catch (Exception e) {
			this.rotate = false;
		}
		try {
			String[] axis = json.get("axis").getAsString().split(" ");
			for (int i = 0; i < axis.length; i++) {
				this.rotationAxis[i] = Float.parseFloat(axis[i]);
			}
		} catch (Exception ignored) {
		}

		try {
			this.blendMode = parseBlend(json.get("blend").getAsString());
		} catch (Exception ignored) {
		}
		showMoon = true;
		showSun = true;
	}

	protected int convertToTicks(int hourFormat) {
		hourFormat *= 10;
		hourFormat -= 6000;
		if (hourFormat < 0) {
			hourFormat += 24000;
		}
		if (hourFormat >= 24000) {
			hourFormat -= 24000;
		}
		return hourFormat;
	}

	@Override
	public void renderSkybox() {
		C_5786166 tessellator = C_5786166.m_2065116();
		C_8373595 bufferBuilder = tessellator.m_1454391();

		C_8105098.m_0408063().m_1218956().m_5325521(textures[0]);
		for (int i = 0; i < 6; ++i) {
			C_3754158.m_8373640();

			double u;
			double v;

			if (i == 0) {
				u = 0;
				v = 0;
			} else if (i == 1) {
				C_3754158.m_8616673(90.0F, 1.0F, 0.0F, 0.0F);
				u = 1 / 3D;
				v = 0.5D;
			} else if (i == 2) {
				C_3754158.m_8616673(-90.0F, 1.0F, 0.0F, 0.0F);
				C_3754158.m_8616673(180, 0, 1, 0);
				u = 2 / 3D;
				v = 0F;
			} else if (i == 3) {
				C_3754158.m_8616673(180.0F, 1.0F, 0.0F, 0.0F);
				u = 1 / 3D;
				v = 0F;
			} else if (i == 4) {
				C_3754158.m_8616673(90.0F, 0.0F, 0.0F, 1.0F);
				C_3754158.m_8616673(-90, 0, 1, 0);
				u = 2 / 3D;
				v = 0.5D;
			} else {
				C_3754158.m_8616673(-90.0F, 0.0F, 0.0F, 1.0F);
				C_3754158.m_8616673(90, 0, 1, 0);
				v = 0.5D;
				u = 0;
			}

			bufferBuilder.m_0421390(7, C_4461663.f_4312108);
			bufferBuilder.m_3299851(-100, -100, -100).m_4749889(u, v).m_3978312(1F, 1F, 1F, alpha).m_4365807();
			bufferBuilder.m_3299851(-100, -100, 100).m_4749889(u, v + 0.5).m_3978312(1F, 1F, 1F, alpha).m_4365807();
			bufferBuilder.m_3299851(100, -100, 100).m_4749889(u + 1 / 3F, v + 0.5).m_3978312(1F, 1F, 1F, alpha).m_4365807();
			bufferBuilder.m_3299851(100, -100, -100).m_4749889(u + 1 / 3F, v).m_3978312(1F, 1F, 1F, alpha).m_4365807();

			tessellator.m_8222644();

			C_3754158.m_2041265();
		}
	}
}
