/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.tnttime;

import java.text.DecimalFormat;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.IntegerOption;
import io.github.axolotlclient.modules.AbstractModule;
import io.github.axolotlclient.util.options.ForceableBooleanOption;
import lombok.Getter;
import net.minecraft.unmapped.C_1716360;
import net.minecraft.unmapped.C_1945050;
import net.minecraft.unmapped.C_6237110;
import net.minecraft.unmapped.C_9550253;

public class TntTime extends AbstractModule {

	@Getter
	private static final TntTime Instance = new TntTime();
	public final ForceableBooleanOption enabled = new ForceableBooleanOption("enabled", false);
	private final OptionCategory category = OptionCategory.create("tnttime");
	private final IntegerOption decimalPlaces = new IntegerOption("decimalplaces", 2, 0, 6);
	private DecimalFormat format = new DecimalFormat("##");
	private int decimals;

	@Override
	public void init() {
		category.add(enabled, decimalPlaces);
		AxolotlClient.config().rendering.add(category);
	}

	@Override
	public void tick() {
		if (decimalPlaces.get() != decimals) {
			StringBuilder string = new StringBuilder("#0");
			if (decimalPlaces.get() > 0) {
				string.append(".");
				for (int i = 0; i < decimalPlaces.get(); i++) {
					string.append("0");
				}
			}
			format = new DecimalFormat(string.toString());
			decimals = decimalPlaces.get();
		}
	}

	public C_9550253 getFuseTime(int time) {
		float secs = time / 20F;
		return new C_1716360(format.format(secs)).m_4053634().m_7551367(new C_6237110().m_0282611(getCurrentColor(secs)));
	}

	private C_1945050 getCurrentColor(float seconds) {
		if (seconds > 7d) {
			return C_1945050.f_2296475;
		} else if (seconds > 6d) {
			return C_1945050.f_0440484;
		} else if (seconds > 4d) {
			return C_1945050.f_1377263;
		} else if (seconds > 3d) {
			return C_1945050.f_7735202;
		} else if (seconds > 2d) {
			return C_1945050.f_0313642;
		} else if (seconds > 1d) {
			return C_1945050.f_9213701;
		} else if (seconds > 0d) {
			return C_1945050.f_3447522;
		} else {
			return C_1945050.f_5887713;
		}
	}
}
