/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.util;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.api.requests.UserRequest;
import io.github.axolotlclient.modules.hypixel.NickHider;
import net.minecraft.unmapped.C_0539808;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_9590849;

public class BadgeRenderer {
	public static void renderNametagBadge(C_0539808 entity) {
		if (!(entity instanceof C_9590849) || entity.m_4153657()) {
			return;
		}

		if (!AxolotlClient.config().showBadges.get() || !UserRequest.getOnline(entity.m_2013188().toString())) {
			return;
		}

		C_3831727 textRenderer = C_8105098.m_0408063().f_0426313;

		int x = -(textRenderer
			.m_0040387(entity.m_2013188() == C_8105098.m_0408063().f_7663840.m_2013188()
				? (NickHider.getInstance().hideOwnName.get() ? NickHider.getInstance().hiddenNameSelf.get()
				: entity.m_0699887().m_2117196())
				: (NickHider.getInstance().hideOtherNames.get() ? NickHider.getInstance().hiddenNameOthers.get()
				: entity.m_0699887().m_2117196()))
			/ 2
			+ (AxolotlClient.config().customBadge.get() ? textRenderer
			.m_0040387(" " + AxolotlClient.config().badgeText.get()) : 10));

		C_3754158.m_3323122(1, 1, 1, 1);

		if (AxolotlClient.config().customBadge.get())
			textRenderer.m_4413321(AxolotlClient.config().badgeText.get(), x, 0, -1, AxolotlClient.config().useShadows.get());
		else {
			C_8105098.m_0408063().m_1218956().m_5325521(AxolotlClient.badgeIcon);
			C_2691939.m_5935491(x, 0, 0, 0, 8, 8, 8, 8);
		}
	}
}
