/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.util;

import java.awt.image.BufferedImage;
import java.io.IOException;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_0979881;
import net.minecraft.unmapped.C_3779718;
import net.minecraft.unmapped.C_8105098;
import net.ornithemc.osl.resource.loader.api.ResourceLoaderEvents;

/**
 * This utility allows us to separate the texture atlas parts in order to be able to make use of nine-slicing
 */
public class ButtonWidgetTextures {
	private static C_0561170 disabledTexture, activeTexture, hoveredTexture;

	static {
		ResourceLoaderEvents.END_RESOURCE_RELOAD.register(() -> {
			C_8105098.m_0408063().m_1218956().m_3775266(disabledTexture);
			C_8105098.m_0408063().m_1218956().m_3775266(activeTexture);
			C_8105098.m_0408063().m_1218956().m_3775266(hoveredTexture);
			disabledTexture = activeTexture = hoveredTexture = null;
		});
	}

	private static void load() {
		if (hoveredTexture != null) {
			return;
		}
		var mc = C_8105098.m_0408063();
		var resMan = mc.m_3739907();
		try {

			BufferedImage img = C_0979881.m_2641486(resMan.m_5942034(new C_0561170("textures/gui/widgets.png")).m_3098790());
			disabledTexture = register(img, "disabled", 46);
			activeTexture = register(img, "active", 46 + 20);
			hoveredTexture = register(img, "hovered", 46 + 40);

		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	private static C_0561170 register(BufferedImage atlas, String name, int imageY) {
		var id = new C_0561170("axolotlclient", "minecraft/buttonwidget/" + name);
		int scale = atlas.getHeight() / 256;
		var texture = new C_3779718(atlas.getSubimage(0, imageY * scale, 200 * scale, 20 * scale));
		C_8105098.m_0408063().m_1218956().m_0381205(id, texture);
		return id;
	}

	public static C_0561170 get(int state) {
		load();
		return switch (state) {
			case 2 -> hoveredTexture;
			case 1 -> activeTexture;
			default -> disabledTexture;
		};
	}
}
