/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.util.notifications;

import io.github.axolotlclient.util.notifications.toasts.ToastManager;
import lombok.Getter;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_8105098;

public class Notifications implements NotificationProvider {
	@Getter
	private static final Notifications Instance = new Notifications();
	private final C_8105098 client = C_8105098.m_0408063();
	@Getter
	private final ToastManager toastManager = new ToastManager(client);

	public void addStatus(String title, String description, Object... args) {
		toastManager.addToast(AxolotlClientToast.multiline(client, C_3390001.m_2053009(title, args), C_3390001.m_2053009(description, args)));
	}
}

