/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.util.options.rounded;

import java.util.Base64;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Graphics;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.GraphicsOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.rounded.screen.GraphicsEditorScreen;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.rounded.widgets.GraphicsWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.rounded.widgets.RoundedButtonWidget;
import io.github.axolotlclient.util.notifications.Notifications;

public class AxoGraphicsWidget extends GraphicsWidget {
	private final GraphicsOption option;

	public AxoGraphicsWidget(int x, int y, int width, int height, GraphicsOption option) {
		super(x, y, width, height, option);
		this.option = option;
	}

	@Override
	public void onPress() {
		client.m_6408915(new AxoGraphicsEditorScreen(client.f_0723335, this.option));
	}

	public static class AxoGraphicsEditorScreen extends GraphicsEditorScreen {
		private final Graphics graphics;

		public AxoGraphicsEditorScreen(C_3020744 parent, GraphicsOption option) {
			super(parent, option);
			this.graphics = option.get();
		}

		@Override
		public void m_3593494() {
			super.m_3593494();

			int buttonX = gridX + maxGridWidth + 10;
			int buttonY = gridY + 60;
			var back = (RoundedButtonWidget) children().get(children().size() - 1);
			remove(back);
			addDrawableChild(new RoundedButtonWidget(buttonX, buttonY + 25, C_3390001.m_2053009("graphics.copy_text"),
				btn -> m_5360526(Base64.getEncoder().encodeToString(graphics.getPixelData())))).setWidth(100);
			addDrawableChild(new RoundedButtonWidget(buttonX, buttonY + 50, C_3390001.m_2053009("graphics.paste_text"),
				btn -> {
					try {
						graphics.setPixelData(Base64.getDecoder().decode(m_5577529()));
					} catch (IllegalArgumentException e) {
						Notifications.getInstance().addStatus("graphics.paste_text.failed", "graphics.paste_text.failed.desc");
					}
				})).setWidth(100);
			addDrawableChild(back);
		}
	}
}
