/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class ContextMenuContainer implements class_4068, class_364 {

	@Getter
	@Setter
	@Nullable
	private ContextMenu menu;

	public ContextMenuContainer() {

	}

	public void removeMenu() {
		menu = null;
	}

	public boolean hasMenu() {
		return menu != null;
	}

	@Override
	public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
		if (menu != null) {
			menu.method_25394(matrices, mouseX, mouseY, delta);
		}
	}

	@Override
	public void method_16014(double mouseX, double mouseY) {
		if (menu != null) {
			menu.method_16014(mouseX, mouseY);
		}
	}

	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		if (menu != null) {
			if (!menu.method_25405(mouseX, mouseY)) {
				removeMenu();
				return true;
			}
			if (menu.method_25402(mouseX, mouseY, button)) removeMenu();
			return true;
		}
		return false;
	}

	@Override
	public boolean method_25406(double mouseX, double mouseY, int button) {
		if (menu != null) {
			return menu.method_25406(mouseX, mouseY, button);
		}
		return false;
	}

	@Override
	public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
		if (menu != null) {
			return menu.method_25403(mouseX, mouseY, button, deltaX, deltaY);
		}
		return false;
	}

	@Override
	public boolean method_25401(double mouseX, double mouseY, double amount) {
		if (menu != null) {
			return menu.method_25401(mouseX, mouseY, amount);
		}
		return false;
	}

	@Override
	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		if (menu != null) {
			return menu.method_25404(keyCode, scanCode, modifiers);
		}
		return false;
	}

	@Override
	public boolean method_16803(int keyCode, int scanCode, int modifiers) {
		if (menu != null) {
			return menu.method_16803(keyCode, scanCode, modifiers);
		}
		return false;
	}

	@Override
	public boolean method_25400(char chr, int modifiers) {
		if (menu != null) {
			return menu.method_25400(chr, modifiers);
		}
		return false;
	}

	@Override
	public boolean method_25405(double mouseX, double mouseY) {
		if (menu != null) {
			return menu.method_25405(mouseX, mouseY);
		}
		return false;
	}
}
