/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import java.util.stream.Collectors;
import net.minecraft.class_2588;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import io.github.axolotlclient.api.chat.ChatScreen;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.requests.FriendRequest;
import io.github.axolotlclient.api.util.AlphabeticalComparator;

public class FriendsScreen extends class_437 {

	private final class_437 parent;

	private UserListWidget widget;

	private class_4185 chatButton, removeButton, onlineTab, allTab, pendingTab, blockedTab;
	private class_4185 denyButton, acceptButton, unblockButton, cancelButton;

	private Tab current = Tab.ONLINE;

	protected FriendsScreen(class_437 parent, Tab tab) {
		this(parent);
		current = tab;
	}

	public FriendsScreen(class_437 parent) {
		super(new class_2588("api.screen.friends"));
		this.parent = parent;
	}

	@Override
	public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
		this.method_25420(matrices);
		this.widget.method_25394(matrices, mouseX, mouseY, delta);
		method_27534(matrices, this.field_22793, this.field_22785, this.field_22789 / 2, 20, 16777215);
		super.method_25394(matrices, mouseX, mouseY, delta);
	}

	@Override
	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		if (super.method_25404(keyCode, scanCode, modifiers)) {
			return true;
		} else if (keyCode == 294) {
			this.refresh();
			return true;
		} else if (this.widget.method_25334() != null) {
			if (keyCode != 257 && keyCode != 335) {
				return this.widget.method_25404(keyCode, scanCode, modifiers);
			} else {
				this.openChat();
				return true;
			}
		} else {
			return false;
		}
	}

	@Override
	protected void method_25426() {
		method_25429(widget = new UserListWidget(this, field_22787, field_22789, field_22790, 32, field_22790 - 64, 35));

		widget.method_25396().clear();

		if (current == Tab.ALL || current == Tab.ONLINE) {
			FriendRequest.getInstance().getFriends().whenCompleteAsync((list, t) -> widget.setUsers(list.stream().sorted((u1, u2) ->
				new AlphabeticalComparator().compare(u1.getName(), u2.getName())).filter(user -> {
				if (current == Tab.ONLINE) {
					return user.getStatus().isOnline();
				}
				return true;
			}).collect(Collectors.toList())));
		} else if (current == Tab.PENDING) {
			FriendRequest.getInstance().getFriendRequests().whenCompleteAsync((con, th) -> {

				con.getLeft().stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName()))
					.forEach(user -> widget.addEntry(new UserListWidget.UserListEntry(user, new class_2588("api.friends.pending.incoming"))));
				con.getRight().stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName()))
					.forEach(user -> widget.addEntry(new UserListWidget.UserListEntry(user, new class_2588("api.friends.pending.outgoing")).outgoing()));
			});
		} else if (current == Tab.BLOCKED) {
			FriendRequest.getInstance().getBlocked().whenCompleteAsync((list, th) -> widget.setUsers(list.stream().sorted((u1, u2) ->
				new AlphabeticalComparator().compare(u1.getName(), u2.getName())).collect(Collectors.toList())));
		}

		this.method_25411(blockedTab = new class_4185(this.field_22789 / 2 + 24, this.field_22790 - 52, 57, 20,
			new class_2588("api.friends.tab.blocked"), button ->
			field_22787.method_1507(new FriendsScreen(parent, Tab.BLOCKED))));

		this.method_25411(pendingTab = new class_4185(this.field_22789 / 2 - 34, this.field_22790 - 52, 57, 20,
			new class_2588("api.friends.tab.pending"), button ->
			field_22787.method_1507(new FriendsScreen(parent, Tab.PENDING))));

		this.method_25411(allTab = new class_4185(this.field_22789 / 2 - 94, this.field_22790 - 52, 57, 20,
			new class_2588("api.friends.tab.all"), button ->
			field_22787.method_1507(new FriendsScreen(parent, Tab.ALL))));

		this.method_25411(onlineTab = new class_4185(this.field_22789 / 2 - 154, this.field_22790 - 52, 57, 20,
			new class_2588("api.friends.tab.online"), button ->
			field_22787.method_1507(new FriendsScreen(parent, Tab.ONLINE))));

		this.method_25411(new class_4185(this.field_22789 / 2 + 88, this.field_22790 - 52, 66, 20,
			new class_2588("api.friends.add"),
			button -> field_22787.method_1507(new AddFriendScreen(this))));

		this.removeButton = this.method_25411(new class_4185(this.field_22789 / 2 - 50, this.field_22790 - 28, 100, 20,
			new class_2588("api.friends.remove"), button -> {
			UserListWidget.UserListEntry entry = this.widget.method_25334();
			if (entry != null) {
				removeButton.field_22763 = false;
				FriendRequest.getInstance().removeFriend(entry.getUser()).thenRun(() -> client.execute(this::refresh));
			}
		}));

		method_25411(denyButton = new class_4185(this.field_22789 / 2 - 50, this.field_22790 - 28, 48, 20,
			new class_2588("api.friends.request.deny"),
			button -> denyRequest()));

		method_25411(acceptButton = new class_4185(this.field_22789 / 2 + 2, this.field_22790 - 28, 48, 20,
			new class_2588("api.friends.request.accept"),
			button -> acceptRequest()));

		unblockButton = method_25411(new class_4185(this.field_22789 / 2 - 50, this.field_22790 - 28, 100, 20, new class_2588("api.users.unblock"),
			b -> {
				b.field_22763 = false;
				FriendRequest.getInstance().unblockUser(widget.method_25334().getUser()).thenRun(() -> client.execute(this::refresh));
			}));
		cancelButton = method_25411(new class_4185(this.field_22789 / 2 - 50, this.field_22790 - 28, 100, 20, class_5244.field_24335, b -> {
			b.field_22763 = false;
			FriendRequest.getInstance().cancelFriendRequest(widget.method_25334().getUser()).thenRun(() -> client.execute(this::refresh));
		}));

		this.method_25411(chatButton = new class_4185(this.field_22789 / 2 - 154, this.field_22790 - 28, 100, 20,
			new class_2588("api.friends.chat"), button -> openChat()));

		this.method_25411(
			new class_4185(this.field_22789 / 2 + 4 + 50, this.field_22790 - 28, 100, 20,
				class_5244.field_24339, button -> this.field_22787.method_1507(this.parent)));
		updateButtonActivationStates();
	}

	private void refresh() {
		field_22787.method_1507(new FriendsScreen(parent));
	}

	private void denyRequest() {
		UserListWidget.UserListEntry entry = widget.method_25334();
		if (entry != null) {
			denyButton.field_22763 = false;
			FriendRequest.getInstance().denyFriendRequest(entry.getUser()).thenRun(() -> client.execute(this::refresh));
		}
	}

	private void acceptRequest() {
		UserListWidget.UserListEntry entry = widget.method_25334();
		if (entry != null) {
			acceptButton.field_22763 = false;
			FriendRequest.getInstance().acceptFriendRequest(entry.getUser()).thenRun(() -> client.execute(this::refresh));
		}
	}

	private void updateButtonActivationStates() {
		UserListWidget.UserListEntry entry = widget.method_25334();
		chatButton.field_22763 = entry != null && (current == Tab.ALL || current == Tab.ONLINE);

		removeButton.field_22764 = true;
		unblockButton.field_22763 = removeButton.field_22763 = entry != null;
		denyButton.field_22764 = false;
		acceptButton.field_22764 = unblockButton.field_22764 = cancelButton.field_22764 = false;
		if (current == Tab.ONLINE) {
			onlineTab.field_22763 = false;
			allTab.field_22763 = pendingTab.field_22763 = blockedTab.field_22763 = true;
		} else if (current == Tab.ALL) {
			allTab.field_22763 = false;
			onlineTab.field_22763 = pendingTab.field_22763 = blockedTab.field_22763 = true;
		} else if (current == Tab.PENDING) {
			pendingTab.field_22763 = false;
			onlineTab.field_22763 = allTab.field_22763 = blockedTab.field_22763 = true;
			removeButton.field_22764 = false;

			if (entry != null && entry.isOutgoingRequest()) {
				cancelButton.field_22764 = true;
			} else {
				denyButton.field_22764 = true;
				acceptButton.field_22764 = true;
			}
			denyButton.field_22763 = acceptButton.field_22763 = entry != null;
		} else if (current == Tab.BLOCKED) {
			blockedTab.field_22763 = false;
			onlineTab.field_22763 = allTab.field_22763 = pendingTab.field_22763 = true;
			removeButton.field_22764 = false;
			unblockButton.field_22764 = true;
		}
	}

	public void openChat() {
		if (!chatButton.field_22763) {
			return;
		}
		UserListWidget.UserListEntry entry = widget.method_25334();
		if (entry != null) {
			chatButton.field_22763 = false;
			ChannelRequest.getOrCreateDM(entry.getUser())
				.thenAccept(c -> client.execute(() -> client.openScreen(new ChatScreen(this, c))));
		}
	}

	public void select(UserListWidget.UserListEntry entry) {
		this.widget.method_25313(entry);
		this.updateButtonActivationStates();
	}

	public enum Tab {
		ONLINE,
		ALL,
		PENDING,
		BLOCKED
	}
}
