/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import java.net.URI;
import java.util.concurrent.CompletableFuture;

import io.github.axolotlclient.util.OSUtil;
import net.minecraft.class_2588;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5489;

public class PrivacyNoticeScreen extends class_437 {

	private static final URI TERMS_URI = URI.create(Constants.TERMS);

	private final class_437 parent;
	private final CompletableFuture<Boolean> accepted;
	private class_5489 message;

	protected PrivacyNoticeScreen(class_437 parent, CompletableFuture<Boolean> accepted) {
		super(new class_2588("api.privacyNotice"));
		this.parent = parent;
		this.accepted = accepted;
	}

	@Override
	public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
		method_25420(matrices);
		super.method_25394(matrices, mouseX, mouseY, delta);
		method_27534(matrices, this.field_22793, this.field_22785, this.field_22789 / 2, getTitleY(), -1);
		message.method_30888(matrices, field_22789 / 2, getMessageY());
	}

	@Override
	public String method_25435() {
		return super.method_25435() + ". " + new class_2588("api.privacyNotice.description").getString();
	}

	@Override
	protected void method_25426() {

		message = class_5489.method_30890(field_22787.field_1772,
			new class_2588("api.privacyNotice.description"), field_22789 - 50);
		int y = class_3532.method_15340(this.getMessageY() + this.getMessagesHeight() + 20, this.field_22790 / 6 + 96, this.field_22790 - 24);
		this.addButtons(y);
	}

	private void addButtons(int y) {
		method_25411(new class_4185(field_22789 / 2 - 50, y, 100, 20,
			new class_2588("api.privacyNotice.accept"), buttonWidget -> {
			field_22787.method_1507(parent);
			APIOptions.getInstance().privacyAccepted.set(Options.PrivacyPolicyState.ACCEPTED);
			accepted.complete(true);
		}));
		method_25411(new class_4185(field_22789 / 2 + 55, y, 100, 20,
			new class_2588("api.privacyNotice.deny"), buttonWidget -> {
			field_22787.method_1507(parent);
			APIOptions.getInstance().enabled.set(false);
			APIOptions.getInstance().privacyAccepted.set(Options.PrivacyPolicyState.DENIED);
			accepted.complete(false);
		}));
		method_25411(new class_4185(field_22789 / 2 - 155, y, 100, 20,
			new class_2588("api.privacyNotice.openPolicy"), buttonWidget -> {
			OSUtil.getOS().open(TERMS_URI);
		}));
	}

	private int getTitleY() {
		int i = (this.field_22790 - this.getMessagesHeight()) / 2;
		return class_3532.method_15340(i - 20 - 9, 10, 80);
	}

	private int getMessageY() {
		return this.getTitleY() + 20;
	}

	private int getMessagesHeight() {
		return this.message.method_30887() * 9;
	}
}
