/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import com.google.gson.JsonObject;
import io.github.axolotlclient.api.e4mc.E4mcStatusProvider;
import io.github.axolotlclient.api.requests.StatusUpdate;
import io.github.axolotlclient.api.util.StatusUpdateProvider;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_500;
import net.minecraft.class_642;

public class StatusUpdateProviderImpl implements StatusUpdateProvider {

	@Override
	public void initialize() {

	}

	@Override
	public Request getStatus() {
		class_642 entry = class_310.method_1551().method_1558();
		if (entry != null) {

			if (!entry.method_2994()) {
				// None of these selected servers support CTS versions
				/*Optional<StatusUpdate.SupportedServer> optional = Arrays.stream(StatusUpdate.SupportedServer.values()).filter(s -> s.getAddress().matcher(entry.address).matches()).findFirst();
				if (optional.isPresent()) {
					StatusUpdate.SupportedServer server = optional.get();

				}*/
				return StatusUpdate.inGameServer(entry.field_3752, entry.field_3761);
			}
			return StatusUpdate.inGameUnknown(entry.field_3752);
		} else if (class_310.method_1551().method_1576() != null) {
			var e4mcStatus = E4mcStatusProvider.getStatusDescription();
			if (e4mcStatus != null) {
				return StatusUpdate.e4mcStatusUpdate(e4mcStatus);
			}
			return StatusUpdate.inGameUnknown(class_310.method_1551().method_1576().method_27728().method_150());
		}
		class_437 current = class_310.method_1551().field_1755;
		if (current instanceof class_442) {
			return StatusUpdate.online(StatusUpdate.MenuId.MAIN_MENU);
		} else if (current instanceof class_500) {
			return StatusUpdate.online(StatusUpdate.MenuId.SERVER_LIST);
		} else if (current != null) {
			return StatusUpdate.online(StatusUpdate.MenuId.SETTINGS);
		}
		return null;
	}

	private String getOrEmpty(JsonObject object, String name) {
		return object.has(name) ? object.get(name).getAsString() : "";
	}
}
