/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import java.util.List;
import java.util.stream.Collectors;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.api.types.PkSystem;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.modules.auth.Auth;
import lombok.Getter;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4280;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class UserListWidget extends class_4280<UserListWidget.UserListEntry> {

	private final FriendsScreen screen;

	public UserListWidget(FriendsScreen screen, class_310 client, int width, int height, int top, int bottom, int entryHeight) {
		super(client, width, height, top, bottom, entryHeight);
		this.screen = screen;
	}

	public void setUsers(List<User> users) {
		users.forEach(user -> addEntry(new UserListEntry(user)));
	}

	@Override
	public int method_25322() {
		return super.method_25322() + 85;
	}

	public int addEntry(UserListEntry entry) {
		return super.method_25321(entry.init(screen));
	}

	@Override
	protected int method_25329() {
		return super.method_25329() + 30;
	}

	@Override
	public boolean method_25316() {
		return this.screen.method_25399() == this;
	}

	public static class UserListEntry extends class_4280.class_4281<UserListEntry> {

		@Getter
		private final User user;
		private final class_310 client;
		private long time;
		private class_2561 note;
		private FriendsScreen screen;

		@Getter
		private boolean outgoingRequest;

		public UserListEntry(User user, class_5250 note) {
			this(user);
			this.note = note.method_27692(class_124.field_1056);
		}

		public UserListEntry(User user) {
			this.client = class_310.method_1551();
			this.user = user;
		}

		public UserListEntry init(FriendsScreen screen) {
			this.screen = screen;
			return this;
		}

		public UserListEntry outgoing() {
			outgoingRequest = true;
			return this;
		}

		@Override
		public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
			if (user.isSystem()) {
				String fronters = user.getSystem().getFronters().stream()
					.map(PkSystem.Member::getDisplayName).collect(Collectors.joining("/"));
				String tag = class_124.field_1056 + class_124.field_1080.toString() + "(" + user.getSystem().getName() + "/" + user.getName() + ")";
				client.field_1772.method_1729(matrices, fronters + " " + tag, x + 3, y + 1, -1);
			} else {
				client.field_1772.method_1729(matrices, user.getName(), x + 3 + 33, y + 1, -1);
			}

			if (user.getStatus().isOnline() && user.getStatus().getActivity() != null) {
				client.field_1772.method_1729(matrices, user.getStatus().getTitle(), x + 3 + 33, y + 12, 8421504);
				client.field_1772.method_1729(matrices, user.getStatus().getDescription(), x + 3 + 40, y + 23, 8421504);
			} else if (user.getStatus().getLastOnline() != null) {
				client.field_1772.method_1729(matrices, user.getStatus().getLastOnline(), x + 3 + 33, y + 12, 8421504);
			}

			if (note != null) {
				client.field_1772.method_30883(matrices, note, x + entryWidth - client.field_1772.method_27525(note) - 4, y + entryHeight - 10, 8421504);
			}

			client.method_1531().method_22813(Auth.getInstance().getSkinTexture(user.getUuid(), user.getName()));
			RenderSystem.enableBlend();
			method_25293(matrices, x - 1, y - 1, 33, 33, 8, 8, 8, 8, 64, 64);
			method_25293(matrices, x - 1, y - 1, 33, 33, 40, 8, 8, 8, 64, 64);
			RenderSystem.disableBlend();
		}

		@Override
		public boolean method_25402(double mouseX, double mouseY, int button) {
			this.screen.select(this);
			if (class_156.method_658() - this.time < 250L && client.field_1687 == null) {
				screen.openChat();
			}

			this.time = class_156.method_658();
			return false;
		}
	}
}
