/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import java.util.Collections;
import java.util.List;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import com.google.common.collect.ImmutableList;
import io.github.axolotlclient.api.requests.AccountUsernameRequest;
import io.github.axolotlclient.api.types.User;

public class UsernameManagementScreen extends class_437 {

	private final class_437 parent;
	private UsernameListWidget widget;

	public UsernameManagementScreen(class_437 parent) {
		super(new class_2588("api.account.usernames"));
		this.parent = parent;
	}

	@Override
	protected void method_25426() {
		if (API.getInstance().isAuthenticated()) {
			widget = new UsernameListWidget(API.getInstance().getSelf().getPreviousUsernames());
		} else {
			widget = new UsernameListWidget(Collections.emptyList());
		}
		method_25429(widget);
		method_25411(new class_4185(field_22789 / 2 - 75, field_22790 - 25 - 20, 150, 20, new class_2588("gui.back"), b -> field_22787.method_1507(parent)));
	}

	@Override
	public void method_25394(class_4587 graphics, int mouseX, int mouseY, float delta) {
		method_25420(graphics);
		widget.method_25394(graphics, mouseX, mouseY, delta);
		super.method_25394(graphics, mouseX, mouseY, delta);
		method_27534(graphics, field_22793, method_25440(), field_22789 / 2, 25, -1);
	}

	@Override
	public void method_25410(class_310 client, int width, int height) {
		widget.method_25323(width, height, 45, height - 55);
		super.method_25410(client, width, height);
	}

	private class UsernameListWidget extends class_4265<UsernameListWidget.UsernameListEntry> {

		public UsernameListWidget(List<User.OldUsername> names) {
			super(UsernameManagementScreen.this.field_22787, UsernameManagementScreen.this.field_22789, UsernameManagementScreen.this.field_22790, 45, UsernameManagementScreen.this.field_22790 - 55, 20);
			names.forEach(n -> method_25321(new UsernameListEntry(n)));

		}

		@Override
		public int method_25322() {
			return 310;
		}

		private class UsernameListEntry extends Entry<UsernameListEntry> {

			private final class_4185 visibility;
			private final class_4185 delete;
			private final String name;

			public UsernameListEntry(User.OldUsername name) {
				visibility = new class_4185(0, 0, 100, 20, new class_2588("api.account.usernames.public", name.isPub()), w -> {
					name.setPub(!name.isPub());
					w.method_25355(new class_2588("api.account.usernames.public", name.isPub()));
					AccountUsernameRequest.post(name.getName(), name.isPub());
				});
				delete = new class_4185(0, 0, 100, 20, new class_2588("api.account.usernames.delete"), w -> {
					field_22740.method_1507(new class_410(b -> {
						if (b) {
							AccountUsernameRequest.delete(name.getName()).thenRun(() ->
								UsernameListWidget.this.method_25330(this));
						}
						field_22740.method_1507(UsernameManagementScreen.this);
					}, new class_2588("api.account.confirm_deletion"),
						new class_2588("api.account.usernames.delete.desc")));
				});

				this.name = name.getName();
			}

			@Override
			public List<? extends class_364> children() {
				return ImmutableList.of(visibility, delete);
			}

			@Override
			public void render(class_4587 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
				int deleteX = UsernameListWidget.this.method_25329() - delete.method_25368() - 10;
				delete.field_22760 = deleteX;
				delete.field_22761 = y - 2;
				visibility.field_22760 = deleteX - visibility.method_25368() - 5;
				visibility.field_22761 = y - 2;
				delete.method_25394(graphics, mouseX, mouseY, tickDelta);
				visibility.method_25394(graphics, mouseX, mouseY, tickDelta);
				field_22793.method_1720(graphics, name, x, y + entryHeight / 2f - 9 / 2f, -1);
			}
		}
	}
}
