/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api.chat;

import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.PlainTextButtonWidget;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.types.ChannelInvite;
import io.github.axolotlclient.api.util.UUIDHelper;

public class ChannelInvitesScreen extends class_437 {
	private final class_437 parent;
	private class_4185 acceptButton;
	private class_4185 denyButton;
	private InvitesListWidget invites;

	public ChannelInvitesScreen(class_437 parent) {
		super(new class_2588("api.channels.invites"));
		this.parent = parent;
	}

	@Override
	protected void method_25426() {

		method_25411(new PlainTextButtonWidget(field_22789 / 2 - field_22793.method_27525(field_22785) / 2, 33 / 2, 0, 0, field_22785, w -> {
		}, field_22793));

		invites = method_25429(new InvitesListWidget(field_22787, field_22790, 33, field_22789, field_22790 - 88, 25));


		acceptButton = method_25411(new class_4185(field_22789 / 2 - 75, field_22790 - 55 / 2 - 2 - 20, 73, 20, new class_2588("api.channels.invite.accept"), w -> {
			if (invites.method_25334() != null) {
				w.field_22763 = false;
				ChannelRequest.acceptChannelInvite(invites.method_25334().invite).thenRun(() -> field_22787.execute(() -> method_25423(field_22787, field_22789, field_22790)));
			}
		}));
		denyButton = method_25411(new class_4185(field_22789 / 2 + 2, field_22790 - 55 / 2 - 2 - 20, 73, 20, new class_2588("api.channels.invite.ignore"), w -> {
			if (invites.method_25334() != null) {
				w.field_22763 = false;
				ChannelRequest.ignoreChannelInvite(invites.method_25334().invite).thenRun(() -> field_22787.execute(() -> method_25423(field_22787, field_22789, field_22790)));
			}
		}));
		method_25411(new class_4185(field_22789 / 2 - 75, field_22790 - 55 / 2 + 2, 150, 20, class_5244.field_24339, w -> method_25419()));

		updateButtons();
	}

	@Override
	public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
		invites.method_25394(matrices, mouseX, mouseY, delta);
		super.method_25394(matrices, mouseX, mouseY, delta);
	}

	@Override
	public void method_25419() {
		field_22787.method_1507(parent);
	}

	private void updateButtons() {
		denyButton.field_22763 = acceptButton.field_22763 = invites.method_25334() != null;
	}

	private class InvitesListWidget extends class_4280<InvitesListWidget.InvitesListEntry> {

		public InvitesListWidget(class_310 client, int screenHeight, int y, int width, int height, int entryHeight) {
			super(client, width, screenHeight, y, y + height, entryHeight);
			ChannelRequest.getChannelInvites().thenAccept(list ->
				list.stream().map(InvitesListEntry::new).forEach(this::method_25321));
		}

		@Override
		public boolean method_25402(double mouseX, double mouseY, int button) {
			boolean bl = super.method_25402(mouseX, mouseY, button);
			updateButtons();
			return bl;
		}

		private class InvitesListEntry extends Entry<InvitesListEntry> {

			private final ChannelInvite invite;
			private final CompletableFuture<String> fromName;

			public InvitesListEntry(ChannelInvite invite) {
				this.invite = invite;
				this.fromName = UUIDHelper.tryGetUsernameAsync(invite.fromUuid());
			}

			@Override
			public void render(class_4587 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
				method_27535(graphics, field_22793, new class_2588("api.channels.invite.name", invite.channelName()), left + 2, top + 2, -1);
				if (fromName.isDone()) {
					method_27535(graphics, field_22793, new class_2588("api.channels.invite.from", fromName.join()).method_10862(class_2583.field_24360.method_10978(true)), left + 15, top + height - field_22793.field_2000 - 1, 0x808080);
				}
			}
		}
	}
}
