/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api.chat;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_357;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.AxolotlClientConfig.impl.util.DrawUtil;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.types.Channel;
import io.github.axolotlclient.api.types.Persistence;
import io.github.axolotlclient.api.util.UUIDHelper;

public class ChannelSettingsScreen extends class_437 {
	private final class_437 parent;
	private final Channel channel;

	protected ChannelSettingsScreen(class_437 parent, Channel channel) {
		super(new class_2588("api.channel.configure"));
		this.parent = parent;
		this.channel = channel;
	}

	@Override
	public void method_25394(class_4587 graphics, int mouseX, int mouseY, float delta) {
		method_25420(graphics);
		method_27534(graphics, field_22793, field_22785, field_22789 / 2, 36 / 2 - field_22793.field_2000 / 2, -1);
		super.method_25394(graphics, mouseX, mouseY, delta);
		method_19355(mouseX, mouseY).filter(e -> e instanceof class_4185).map(b -> (class_4185) b).ifPresent(b -> b.method_25352(graphics, mouseX, mouseY));
	}

	@Override
	protected void method_25426() {
		int leftColX = field_22789 / 2 - 4 - 150;
		int leftColYStep = field_22793.field_2000 + 20 - field_22793.field_2000 + 8 - 5 + 5;
		int leftColY = 36 + 5 + 30;
		int rightColX = field_22789 / 2 + 4;
		int rightColYStep = 20 + 8;
		int rightColY = 36 + 30;

		var nameField = new class_342(field_22793, rightColX, rightColY, 150, 20, class_2585.field_24366);
		nameField.method_1852(channel.getRealName());
		method_25411(text("api.chat.groups.name", leftColX, leftColY));
		method_25411(nameField);
		rightColY += rightColYStep;
		leftColY += leftColYStep;

		AtomicReference<Supplier<Integer>> count = new AtomicReference<>();
		AtomicReference<Supplier<Long>> duration = new AtomicReference<>();

		AtomicReference<Consumer<Boolean>> countDisabler = new AtomicReference<>();
		AtomicReference<Consumer<Boolean>> durationDisabler = new AtomicReference<>();
		var persistence = new class_4185(rightColX, rightColY, 150, 20, class_2585.field_24366, a -> {
		}) {
			final Persistence.Type[] values = Persistence.Type.values();
			int current = channel.getPersistence().type().ordinal();

			@Override
			public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
				method_25355(new class_2588("api.chat.persistence." + values[current].getId()));
				super.method_25359(matrices, mouseX, mouseY, delta);
			}

			@Override
			public void method_25306() {
				current++;
				if (current >= values.length) {
					current = 0;
				}
				Persistence.Type object = values[current];
				switch (object) {
					case COUNT_DURATION -> {
						countDisabler.get().accept(true);
						countDisabler.get().accept(true);
					}
					case DURATION -> {
						durationDisabler.get().accept(true);
						countDisabler.get().accept(false);
					}
					case COUNT -> {
						countDisabler.get().accept(true);
						durationDisabler.get().accept(false);
					}
					case CHANNEL -> {
						countDisabler.get().accept(false);
						durationDisabler.get().accept(false);
					}
				}
			}

			public Persistence.Type getValue() {
				return values[current];
			}
		};
		rightColY += rightColYStep;
		method_25411(text("api.chat.groups.persistence", leftColX, leftColY));
		leftColY += leftColYStep;
		method_25411(persistence);
		method_25411(text("api.chat.groups.persistence.count", "api.chat.groups.persistence.count.tooltip", leftColX, leftColY));
		leftColY += leftColYStep;
		countDisabler.set(sliderAssembly(rightColX, rightColY, val -> (int) (val * 100d), count::set, channel.getPersistence().count() / 100d));
		rightColY += rightColYStep;
		method_25411(text("api.chat.groups.persistence.duration", "api.chat.groups.persistence.duration.tooltip", leftColX, leftColY));
		leftColY += leftColYStep;
		durationDisabler.set(sliderAssembly(rightColX, rightColY, val -> (long) (val * 100d), duration::set, channel.getPersistence().duration() / 100d));
		rightColY += rightColYStep;
		countDisabler.get().accept(false);
		durationDisabler.get().accept(false);

		var namesInput = method_25411(new class_342(field_22793, rightColX, rightColY, 150, 20, class_2585.field_24366));
		method_25411(text("api.chat.groups.add_participants", leftColX, leftColY));

		int footerY = field_22790 - 36 / 2 - 20 / 2;
		method_25411(new class_4185(field_22789 / 2 - 150 - 4, footerY, 150, 20, class_5244.field_24335, widget -> field_22787.method_1507(parent)));
		method_25411(new class_4185(field_22789 / 2 + 4, footerY, 150, 20, class_5244.field_24334, widget -> {
			ChannelRequest.updateChannel(channel.getId(), nameField.method_1882(),
				Persistence.of(persistence.getValue(), count.get().get(), duration.get().get()),
				Arrays.stream(namesInput.method_1882().split(",")).filter(s -> !s.isEmpty()).map(UUIDHelper::ensureUuid).toArray(String[]::new));
			field_22787.method_1507(parent);
		}));
	}

	private <T> Consumer<Boolean> sliderAssembly(int x, int y, Function<Double, T> valueFunc, Consumer<Supplier<T>> value, double initialValue) {

		AtomicReference<T> currentVal = new AtomicReference<>();
		var slider = new class_357(x, y, 128, 20, class_2585.field_24366, initialValue) {
			@Override
			protected void method_25346() {
				method_25355(new class_2585(String.valueOf(valueFunc.apply(field_22753))));
			}

			@Override
			protected void method_25344() {
				currentVal.set(valueFunc.apply(field_22753));
			}
		};
		slider.method_25346();
		slider.method_25344();
		value.accept(currentVal::get);
		var text = new class_342(field_22793, x, y, 128, 20, class_2585.field_24366);
		var textButton = new class_4185(x + 130, y, 20, 20, new class_2588("slider.text_input"), w -> {
			if (slider.field_22764) {
				text.field_22760 = slider.field_22760;
				text.field_22761 = slider.field_22761;
				text.method_25358(slider.method_25368());
				text.method_1852(String.valueOf(currentVal.get()));
			} else {
				try {
					slider.method_25348(slider.field_22760 + (1d / slider.method_25368()) * Double.parseDouble(text.method_1882()), slider.field_22761);
				} catch (Exception ignored) {
				}
			}
			slider.field_22764 = !slider.field_22764;
			text.field_22764 = !slider.field_22764;
		}) {
			@SuppressWarnings("deprecation")
			@Override
			public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
				field_22787.method_1531().method_22813(field_22757);
				RenderSystem.color4f(1.0F, 1.0F, 1.0F, this.field_22765);
				int i = this.method_25356(this.method_25367());
				RenderSystem.enableBlend();
				RenderSystem.defaultBlendFunc();
				RenderSystem.enableDepthTest();
				this.method_25302(matrices, this.field_22760, this.field_22761, 0, 46 + i * 20, this.field_22758 / 2, this.field_22759);
				this.method_25302(matrices, this.field_22760 + this.field_22758 / 2, this.field_22761, 200 - this.field_22758 / 2, 46 + i * 20, this.field_22758 / 2, this.field_22759);
				field_22787.method_1531().method_22813(new class_2960("axolotlclient", "textures/gui/sprites/cursor.png"));
				method_25293(matrices,
					field_22760 + method_25368() / 2 - 4, field_22761 + method_25364() / 2 - 4,
					8, 8, 0, 0, 8, 8, 8, 8);

			}
		};
		text.field_22764 = false;
		method_25411(text);
		method_25411(textButton);
		method_25411(slider);
		return val -> slider.field_22763 = textButton.field_22763 = text.field_22763 = val;
	}

	private class_339 text(String translationKey, int x, int y) {
		class_2561 text = new class_2588(translationKey);
		return new class_339(x, y, 150, field_22793.field_2000, text) {

			@Override
			public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
				DrawUtil.drawScrollingText(matrices, method_25369(), this.field_22760, this.field_22761, this.field_22758, this.field_22759, Colors.WHITE);
			}

			@Override
			public void method_25354(class_1144 soundManager) {
			}
		};
	}

	private class_339 text(String translationKey, String tooltipKey, int x, int y) {
		class_2561 text = new class_2588(translationKey);
		class_339 widget = new class_4185(x, y, 150, field_22793.field_2000, text, a -> {
		}) {

			@Override
			public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
				DrawUtil.drawScrollingText(matrices, method_25369(), this.field_22760, this.field_22761, this.field_22758, this.field_22759, Colors.WHITE);
			}

			@Override
			public void method_25352(class_4587 matrices, int mouseX, int mouseY) {
				ChannelSettingsScreen.this.method_25417(matrices, field_22793.method_1728(new class_2588(tooltipKey), 170), mouseX, mouseY);
			}

			@Override
			public void method_25354(class_1144 soundManager) {
			}
		};
		return widget;
	}
}
