/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api.chat;

import io.github.axolotlclient.api.ContextMenuContainer;
import io.github.axolotlclient.api.ContextMenuScreen;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.types.Channel;
import net.minecraft.class_1074;
import net.minecraft.class_2588;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;

public class ChatListScreen extends class_437 implements ContextMenuScreen {

	private final class_437 parent;
	private final ContextMenuContainer container;
	private ChatListWidget dms;
	private ChatListWidget groups;

	public ChatListScreen(class_437 parent) {
		super(new class_2588("api.chats"));
		this.parent = parent;
		container = new ContextMenuContainer();
	}

	@Override
	public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
		method_25434(0);
		dms.method_25394(matrices, mouseX, mouseY, delta);
		groups.method_25394(matrices, mouseX, mouseY, delta);
		super.method_25394(matrices, mouseX, mouseY, delta);
		container.method_25394(matrices, mouseX, mouseY, delta);

		method_25300(matrices, field_22787.field_1772, class_1074.method_4662("api.chats"), field_22789 / 2, 20, -1);
		method_25300(matrices, field_22787.field_1772, class_1074.method_4662("api.chat.dms"), field_22789 / 2 + 80, 40, -1);
		method_25300(matrices, field_22787.field_1772, class_1074.method_4662("api.chat.groups"), field_22789 / 2 - 80, 40, -1);
	}

	@Override
	protected void method_25426() {
		groups = method_25429(new ChatListWidget(this, field_22789, field_22790, field_22789 / 2 - 155, 55, 150, field_22790 - 105, c -> !c.isDM()));
		dms = method_25429(new ChatListWidget(this, field_22789, field_22790, field_22789 / 2 + 5, 55, 150, field_22790 - 105, Channel::isDM));

		method_25411(new class_4185(this.field_22789 / 2 + 5, this.field_22790 - 40, 150, 20, class_5244.field_24339, buttonWidget ->
			field_22787.method_1507(parent)));
		method_25411(new class_4185(this.field_22789 / 2 - 155, this.field_22790 - 40, 150, 20, new class_2588("api.chat.groups.create"), buttonWidget ->
			field_22787.method_1507(new CreateChannelScreen(this))));
		ChannelRequest.getChannelList().whenCompleteAsync((list, t) -> {
			groups.addChannels(list);
			dms.addChannels(list);
		});
	}

	@Override
	public ContextMenuContainer getMenuContainer() {
		return container;
	}

	@Override
	public class_437 getParent() {
		return parent;
	}

	@Override
	public class_437 getSelf() {
		return this;
	}

	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		if (container.getMenu() != null) {
			if (container.method_25402(mouseX, mouseY, button)) {
				return true;
			}
			container.removeMenu();
		}
		return super.method_25402(mouseX, mouseY, button);
	}
}
