/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api.chat;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_4587;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.ContextMenu;
import io.github.axolotlclient.api.ContextMenuScreen;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.types.Channel;
import io.github.axolotlclient.api.types.Relation;

public class ChatListWidget extends class_4265<ChatListWidget.ChatListEntry> {

	protected final ContextMenuScreen screen;
	private final Predicate<Channel> predicate;

	public ChatListWidget(ContextMenuScreen screen, int screenWidth, int screenHeight, int x, int y, int width, int height, Predicate<Channel> filter) {
		super(class_310.method_1551(), width, height, y, y + height, 25);
		method_25333(x);
		this.screen = screen;
		this.predicate = filter;
	}

	public void addChannels(List<Channel> channels) {
		channels.stream().filter(predicate).sorted().forEach(c -> method_25396().add(0, new ChatListEntry(c)));
		method_25307(0);
	}

	public void setActiveChannel(Channel channel) {
		method_25396().stream().filter(e -> e.channel.equals(channel))
			.findFirst().ifPresent(c -> c.widget.field_22763 = false);
	}

	@Override
	public int method_25322() {
		return field_22742 - 8;
	}

	@Override
	protected int method_25329() {
		return method_25342() + field_22742 - 6;
	}

	public ChatListWidget(ContextMenuScreen screen, int screenWidth, int screenHeight, int x, int y, int width, int height) {
		this(screen, screenWidth, screenHeight, x, y, width, height, c -> true);
	}

	public class ChatListEntry extends Entry<ChatListEntry> {

		private final Channel channel;
		private final class_4185 widget;

		public ChatListEntry(Channel channel) {
			this.channel = channel;
			widget = new class_4185(0, 0, method_25322(), 20, class_2561.method_30163(channel.getName()),
				buttonWidget -> field_22740.method_1507(new ChatScreen(screen.getParent(), channel)));
		}

		@Override
		public void render(class_4587 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
			widget.field_22760 = x;
			widget.field_22761 = y;
			widget.method_25394(graphics, mouseX, mouseY, tickDelta);
		}

		@Override
		public List<? extends class_364> children() {
			return List.of(widget);
		}

		@Override
		public boolean mouseClicked(double mouseX, double mouseY, int button) {
			if (widget.method_25405(mouseX, mouseY)) {
				if (button == 0) {
					return widget.method_25402(mouseX, mouseY, button);
				} else if (button == 1) {
					ContextMenu.Builder builder = ContextMenu.builder()
						.title(class_2561.method_30163(channel.getName()))
						.spacer()
						.entry(new class_2588("api.channel.configure"), w -> field_22740.method_1507(new ChannelSettingsScreen(ChatListWidget.this.screen.getSelf(), channel)))
						.spacer();
					if (channel.getOwner().equals(API.getInstance().getSelf())) {
						builder.entry(new class_2588("api.channel.delete"), w -> field_22740.method_1507(new class_410(bl -> {
							if (bl) {
								ChannelRequest.leaveOrDeleteChannel(channel).whenComplete((o, throwable) -> field_22740.execute(() -> field_22740.method_1507(screen.getSelf())));
							}
						}, new class_2588("api.channels.delete.confirm"), new class_2588("api.channels.delete.confirm.desc", channel.getName()))));
					} else {
						builder.entry(new class_2588("api.channel.leave"), w -> field_22740.method_1507(new class_410(bl -> {
							if (bl) {
								ChannelRequest.leaveOrDeleteChannel(channel).whenComplete((o, throwable) -> field_22740.execute(() -> field_22740.method_1507(screen.getSelf())));
							}
						}, new class_2588("api.channels.leave.confirm"), channel.getOwner().getRelation() == Relation.FRIEND ?
							new class_2588("api.channels.leave.confirm.desc_add", channel.getName()) :
							new class_2588("api.channels.leave.confirm.desc_invite", channel.getName()))));
					}
					ChatListWidget.this.screen.setContextMenu(builder.build());
					return true;
				}
			}
			return super.mouseClicked(mouseX, mouseY, button);
		}
	}
}
