/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api.chat;

import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.ContextMenuContainer;
import io.github.axolotlclient.api.ContextMenuScreen;
import io.github.axolotlclient.api.handlers.ChatHandler;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.types.Channel;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import org.lwjgl.glfw.GLFW;

public class ChatScreen extends class_437 implements ContextMenuScreen {

	private final Channel channel;
	private final class_437 parent;
	private final ContextMenuContainer contextMenu = new ContextMenuContainer();
	private ChatWidget widget;
	private ChatListWidget chatListWidget;
	private ChatUserListWidget users;
	private class_342 input;

	public ChatScreen(class_437 parent, Channel channel) {
		super(new class_2585(channel.getName()));
		this.channel = channel;
		this.parent = parent;
	}

	@Override
	public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
		method_25434(0);

		if (users != null) {
			users.method_25394(matrices, mouseX, mouseY, delta);
		}

		chatListWidget.method_25394(matrices, mouseX, mouseY, delta);
		widget.method_25394(matrices, mouseX, mouseY, delta);

		super.method_25394(matrices, mouseX, mouseY, delta);

		method_25300(matrices, this.field_22793, channel.getName(), this.field_22789 / 2, 20, 16777215);

		contextMenu.method_25394(matrices, mouseX, mouseY, delta);
	}

	@Override
	protected void method_25426() {
		method_25429(chatListWidget = new ChatListWidget(this, field_22789, field_22790, 0, 30, 55, field_22790 - 90));
		ChannelRequest.getChannelList().thenAccept(chatListWidget::addChannels).thenRun(() -> chatListWidget.setActiveChannel(channel));

		method_25429(widget = new ChatWidget(channel, 65, 30, field_22789 - 155, field_22790 - 90, this));

		users = new ChatUserListWidget(this, field_22787, 80, field_22790 - 20, 30, field_22790 - 60, 25);
		users.method_25333(field_22789 - 80);
		users.setUsers(channel.getAllUsers(), channel);
		method_25429(users);

		//noinspection DataFlowIssue
		method_25411(input = new class_342(field_22787.field_1772, field_22789 / 2 - 150, field_22790 - 50,
			300, 20, new class_2588("api.chat.enterMessage")) {

			@Override
			public boolean method_25404(int keyCode, int scanCode, int modifiers) {
				if (keyCode == GLFW.GLFW_KEY_ENTER && !method_1882().isEmpty()) {
					ChatHandler.getInstance().sendMessage(channel, method_1882());
					method_1852("");
					return true;
				}
				return super.method_25404(keyCode, scanCode, modifiers);
			}
		});

		input.method_1887(new class_2588(channel.isDM() ? "api.chat.messageUser" : "api.chat.messageGroup", channel.getName()).getString());
		input.method_1863(s -> {
			if (s.isEmpty()) {
				input.method_1887(new class_2588(channel.isDM() ? "api.chat.messageUser" : "api.chat.messageGroup", channel.getName()).getString());
			} else {
				input.method_1887("");
			}
		});
		input.method_1880(1024);

		if (channel.getOwner().equals(API.getInstance().getSelf())) {
			method_25411(new class_4185(field_22789 - 60, 5, 50, 20, new class_2588("api.channel.configure"), b -> field_22787.method_1507(new ChannelSettingsScreen(this, channel))));
		}

		this.method_25411(new class_4185(this.field_22789 / 2 - 75, this.field_22790 - 28, 150, 20,
			class_5244.field_24339, button -> this.field_22787.method_1507(this.parent)));

		method_25429(contextMenu);
	}

	@Override
	public void method_25393() {
		input.method_1865();
	}

	@Override
	public void method_25432() {
		if (widget != null) {
			widget.remove();
		}
	}

	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		if (contextMenu.getMenu() != null) {
			if (contextMenu.method_25402(mouseX, mouseY, button)) {
				return true;
			}
			contextMenu.removeMenu();
		}
		return super.method_25402(mouseX, mouseY, button);
	}

	@Override
	public ContextMenuContainer getMenuContainer() {
		return contextMenu;
	}

	@Override
	public class_437 getParent() {
		return parent;
	}

	@Override
	public class_437 getSelf() {
		return this;
	}
}
