/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api.multiplayer;

import java.util.Collections;
import java.util.List;

import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.VanillaButtonWidget;
import io.github.axolotlclient.api.FriendsScreen;
import io.github.axolotlclient.api.handlers.StatusUpdateHandler;
import io.github.axolotlclient.api.requests.FriendRequest;
import lombok.Getter;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_412;
import net.minecraft.class_4185;
import net.minecraft.class_420;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_500;
import net.minecraft.class_5244;
import net.minecraft.class_642;
import net.minecraft.class_644;

public class FriendsMultiplayerScreen extends io.github.axolotlclient.AxolotlClientConfig.impl.ui.Screen {
	@Getter
	private final class_644 pinger = new class_644();
	private final class_437 lastScreen;
	protected FriendsMultiplayerSelectionList serverSelectionList;
	private class_4185 selectButton;
	private class_642 editingServer;
	private boolean initialized;
	private List<class_2561> tooltipText;
	private final class_4185 friendsCountButton = new VanillaButtonWidget(0, 0, 150, 20, new class_2588("api.servers.friends", "..."), button -> {
	});
	private static final class_2561 NO_ONLINE_FRIENDS = new class_2588("api.servers.friends.no_online_friends");

	public FriendsMultiplayerScreen(class_437 lastScreen) {
		super("api.servers.friends.title");
		this.lastScreen = lastScreen;
	}

	@Override
	public void method_25426() {
		super.method_25426();
		if (this.initialized) {
			this.serverSelectionList.method_25323(this.field_22789, this.field_22790, 60, this.field_22790 - 64);
		} else {
			this.serverSelectionList = new FriendsMultiplayerSelectionList(this, this.field_22787, this.field_22789, this.field_22790 - 64 - 60, 60, 36);
		}
		StatusUpdateHandler.addUpdateListener("friends_multiplayer_screen", serverSelectionList::updateEntry);
		this.addDrawableChild(this.serverSelectionList);
		addDrawableChild(new VanillaButtonWidget(this.field_22789 / 2 - 102, 32, 100, 20, new class_2588("api.servers"), button ->
			field_22787.method_1507(new class_500(lastScreen))));
		addDrawableChild(friendsCountButton);
		friendsCountButton.field_22760 = field_22789 / 2 + 2;
		friendsCountButton.field_22761 = 32;
		friendsCountButton.method_25358(100);
		friendsCountButton.field_22763 = false;

		if (!initialized) {
			initialized = true;
			FriendRequest.getInstance().getFriends().thenAccept(friends -> {
				friendsCountButton.method_25355(new class_2588("api.servers.friends", friends.stream().filter(u -> u.getStatus().isOnline()).count()));
				this.serverSelectionList.updateList(friends);
			});
		}

		this.selectButton = this.addDrawableChild(
			new VanillaButtonWidget(field_22789 / 2 - 154, field_22790 - 64 + 12, 100, 20,
				new class_2588("selectServer.select"), buttonx -> this.joinSelectedServer()));
		this.addDrawableChild(new VanillaButtonWidget(field_22789 / 2 - 50, field_22790 - 64 + 12, 100, 20,
			new class_2588("selectServer.direct"), buttonx -> {
			this.editingServer = new class_642(class_1074.method_4662("selectServer.defaultName"), "", false);
			this.field_22787.method_1507(new class_420(this, this::directJoinCallback, this.editingServer));
		}));
		this.addDrawableChild(new VanillaButtonWidget(field_22789 / 2 + 50 + 4, field_22790 - 64 + 12, 100, 20,
			new class_2588("api.friends"), buttonx ->
			this.field_22787.method_1507(new FriendsScreen(this))));
		class_4185 editButton = this.addDrawableChild(new VanillaButtonWidget(field_22789 / 2 - 154, field_22790 - 64 + 12 + 20 + 4, 74, 20,
			new class_2588("selectServer.edit"), buttonx -> {
		}));
		editButton.field_22763 = false;
		class_4185 deleteButton = this.addDrawableChild(new VanillaButtonWidget(field_22789 / 2 - 76, field_22790 - 64 + 12 + 20 + 4, 74, 20,
			new class_2588("selectServer.delete"), buttonx -> {
		}));
		deleteButton.field_22763 = false;
		this.addDrawableChild(
			new VanillaButtonWidget(field_22789 / 2 + 2, field_22790 - 64 + 12 + 20 + 4, 74, 20,
				new class_2588("selectServer.refresh"), buttonx -> this.refreshServerList()));
		this.addDrawableChild(new VanillaButtonWidget(field_22789 / 2 + 80, field_22790 - 64 + 12 + 20 + 4, 74, 20,
			class_5244.field_24339, buttonx -> this.method_25419()));

		this.onSelectedChange();
	}

	@Override
	public void method_25419() {
		this.field_22787.method_1507(this.lastScreen);
	}

	@Override
	public void method_25393() {
		super.method_25393();
		this.pinger.method_3000();
	}

	@Override
	public void method_25432() {
		this.pinger.method_3004();
		StatusUpdateHandler.removeUpdateListener("friends_multiplayer_screen");
	}

	@Override
	public void method_25394(class_4587 guiGraphics, int mouseX, int mouseY, float partialTick) {
		this.tooltipText = null;
		super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
		method_27534(guiGraphics, field_22793, method_25440(), field_22789 / 2, 15, -1);

		if (serverSelectionList.method_25396().isEmpty()) {
			method_27534(guiGraphics, field_22793, NO_ONLINE_FRIENDS, field_22789 / 2, field_22790 / 2 - field_22793.field_2000 / 2, -1);
		}
		if (this.tooltipText != null) {
			this.method_30901(guiGraphics, this.tooltipText, mouseX, mouseY);
		}
	}

	private void refreshServerList() {
		this.field_22787.method_1507(new FriendsMultiplayerScreen(this.lastScreen));
	}

	private void directJoinCallback(boolean confirmed) {
		if (confirmed) {
			this.join(this.editingServer);
		} else {
			this.field_22787.method_1507(this);
		}
	}

	public void joinSelectedServer() {
		FriendsMultiplayerSelectionList.Entry entry = this.serverSelectionList.method_25334();
		this.join(entry.getServerData());
	}

	private void join(class_642 server) {
		if (server == null) {
			return;
		}
		this.field_22787.method_1507(new class_412(this, this.field_22787, server));
	}

	public void setSelected(FriendsMultiplayerSelectionList.Entry selected) {
		this.serverSelectionList.setSelected(selected);
		this.onSelectedChange();
	}

	protected void onSelectedChange() {
		this.selectButton.field_22763 = false;
		FriendsMultiplayerSelectionList.Entry entry = this.serverSelectionList.method_25334();
		if (entry != null && !(entry instanceof FriendsMultiplayerSelectionList.LoadingHeader)) {
			this.selectButton.field_22763 = entry.canJoin();
		}
	}

	public void setDeferredTooltip(List<class_2561> text) {
		this.tooltipText = text;
	}

	public void setDeferredTooltip(class_2561 text) {
		this.tooltipText = Collections.singletonList(text);
	}
}
