/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.impl;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.GraphicsOption;
import io.github.axolotlclient.bridge.render.AxoSprite;
import io.github.axolotlclient.util.Util;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public interface AxoSpriteImpl extends AxoSprite {
	void draw(class_310 client, class_4587 stack, int sX, int sY, int sW, int sH);

	record Simple(class_2960 id, int x, int y, int width, int height) implements AxoSpriteImpl {
		@Override
		public void draw(class_310 client, class_4587 stack, int sX, int sY, int sW, int sH) {
			client.method_1531().method_22813(id);
			class_332.method_25290(stack, sX, sY, x, y, sW, sH, width, height);
		}
	}

	record Vanilla(class_1058 sprite) implements AxoSpriteImpl {
		@Override
		public void draw(class_310 client, class_4587 stack, int sX, int sY, int sW, int sH) {
			class_310.method_1551().method_1531().method_22813(sprite.method_24119().method_24106());
			RenderSystem.color4f(1, 1, 1, 1);
			class_332.method_25298(stack, sX, sY, 0, sW, sH, sprite);
		}
	}

	record Config(GraphicsOption option) implements AxoSpriteImpl {
		@Override
		public void draw(class_310 client, class_4587 stack, int sX, int sY, int sW, int sH) {
			Util.bindTexture(option);
			class_332.method_25290(stack, sX, sY, 0, 0, sW, sH, option.get().getWidth(), option.get().getHeight());
		}
	}
}
