/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin.item;

import io.github.axolotlclient.bridge.item.AxoItem;
import io.github.axolotlclient.bridge.item.AxoItems;
import net.minecraft.class_1802;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = AxoItems.class, remap = false)
public abstract class AxoItemsMixin {
	@Mutable
	@Shadow
	@Final
	public static AxoItem AIR;

	@Mutable
	@Shadow
	@Final
	public static AxoItem IRON_HELMET;

	@Mutable
	@Shadow
	@Final
	public static AxoItem IRON_LEGGINGS;

	@Mutable
	@Shadow
	@Final
	public static AxoItem IRON_CHESTPLATE;

	@Mutable
	@Shadow
	@Final
	public static AxoItem IRON_BOOTS;

	@Mutable
	@Shadow
	@Final
	public static AxoItem IRON_SWORD;

	@Mutable
	@Shadow
	@Final
	public static AxoItem ARROW;

	@Mutable
	@Shadow
	@Final
	public static AxoItem IRON_INGOT;

	@Mutable
	@Shadow
	@Final
	public static AxoItem GOLD_INGOT;

	@Mutable
	@Shadow
	@Final
	public static AxoItem DIAMOND;

	@Mutable
	@Shadow
	@Final
	public static AxoItem EMERALD;

	@Mutable
	@Shadow
	@Final
	public static AxoItem STONE_SWORD;

	@Mutable
	@Shadow
	@Final
	public static AxoItem DIAMOND_SWORD;

	@Mutable
	@Shadow
	@Final
	public static AxoItem DIAMOND_CHESTPLATE;

	@Mutable
	@Shadow
	@Final
	public static AxoItem DIAMOND_BOOTS;

	@Mutable
	@Shadow
	@Final
	public static AxoItem TIPPED_ARROW;

	@Mutable
	@Shadow
	@Final
	public static AxoItem SPECTRAL_ARROW;

	@Mutable
	@Shadow
	@Final
	public static AxoItem STONE;

	@Mutable
	@Shadow
	@Final
	public static AxoItem STONE_PICKAXE;

	@Mutable
	@Shadow
	@Final
	public static AxoItem STONE_AXE;

	@Mutable
	@Shadow
	@Final
	public static AxoItem STONE_SHOVEL;

	@Mutable
	@Shadow
	@Final
	public static AxoItem STONE_HOE;

	@Mutable
	@Shadow
	@Final
	public static AxoItem GLOWSTONE_DUST;

	@Mutable
	@Shadow
	@Final
	public static AxoItem ENDER_EYE;

	@Inject(method = "<clinit>", at = @At("HEAD"), cancellable = true)
	private static void setStaticValues(CallbackInfo info) {
		AIR = class_1802.field_8162;
		IRON_HELMET = class_1802.field_8743;
		IRON_CHESTPLATE = class_1802.field_8523;
		IRON_LEGGINGS = class_1802.field_8396;
		IRON_BOOTS = class_1802.field_8660;
		IRON_SWORD = class_1802.field_8371;
		ARROW = class_1802.field_8107;
		IRON_INGOT = class_1802.field_8620;
		GOLD_INGOT = class_1802.field_8695;
		DIAMOND = class_1802.field_8477;
		EMERALD = class_1802.field_8687;
		STONE_SWORD = class_1802.field_8528;
		DIAMOND_SWORD = class_1802.field_8802;
		DIAMOND_CHESTPLATE = class_1802.field_8058;
		DIAMOND_BOOTS = class_1802.field_8285;
		TIPPED_ARROW = class_1802.field_8087;
		SPECTRAL_ARROW = class_1802.field_8236;
		STONE = class_1802.field_20391;
		STONE_PICKAXE = class_1802.field_8387;
		STONE_AXE = class_1802.field_8062;
		STONE_SHOVEL = class_1802.field_8776;
		STONE_HOE = class_1802.field_8431;
		GLOWSTONE_DUST = class_1802.field_8601;
		ENDER_EYE = class_1802.field_8449;
		info.cancel();
	}
}
