/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin.resource;


import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import io.github.axolotlclient.bridge.resource.AxoResource;
import io.github.axolotlclient.bridge.resource.AxoResourceManager;
import io.github.axolotlclient.bridge.util.AxoIdentifier;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(class_3300.class)
public interface ResourceManagerMixin extends AxoResourceManager {

	@Shadow
	class_3298 getResource(class_2960 identifier) throws IOException;

	@Shadow
	Collection<class_2960> findResources(String resourceType, Predicate<String> pathPredicate);

	@Override
	default Map<AxoIdentifier, AxoResource> br$listResources(String namespace, String prefix, Predicate<AxoIdentifier> filter) {
		// this cast is maybe not ideal
		return findResources(prefix, s -> {
			try {
				return filter.test(AxoIdentifier.of(s));
			} catch (Exception e) {
				return false;
			}
		})
			.stream().map(id -> {
				try {
					return getResource(id);
				} catch (IOException e) {
					return null;
				}
			}).filter(Objects::nonNull)
			.collect(Collectors.toMap(class_3298::method_14483, r -> r));
	}

	@Override
	default AxoResource br$getResource(AxoIdentifier loc) throws IOException {
		return getResource((class_2960) loc);
	}
}
