/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.config.screen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.PlainTextButtonWidget;
import io.github.axolotlclient.bridge.util.AxoText;
import io.github.axolotlclient.credits.Credits;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.modules.hud.util.RenderUtil;
import io.github.axolotlclient.util.ClientColors;

public class CreditsScreen extends class_437 {

	public static final HashMap<String, String[]> externalModuleCredits = new HashMap<>();
	private final class_437 parent;
	private final class_1113 bgm = class_1109.method_4757(class_3417.field_15039, 1, 1);
	private CreditsList creditsList;

	public CreditsScreen(class_437 parent) {
		super(new class_2588("credits"));
		this.parent = parent;
	}

	@Override
	public void method_25420(class_4587 stack) {
		if (AxolotlClient.config().someNiceBackground.get()) { // Credit to pridelib for the colors
			method_25294(stack, 0, 0, field_22789, field_22790 / 6, 0xFFff0018);
			method_25294(stack, 0, field_22790 / 6, field_22789, field_22790 * 2 / 6, 0xFFffa52c);
			method_25294(stack, 0, field_22790 * 2 / 6, field_22789, field_22790 / 2, 0xFFffff41);
			method_25294(stack, 0, field_22790 * 2 / 3, field_22789, field_22790 * 5 / 6, 0xFF0000f9);
			method_25294(stack, 0, field_22790 / 2, field_22789, field_22790 * 2 / 3, 0xFF008018);
			method_25294(stack, 0, field_22790 * 5 / 6, field_22789, field_22790, 0xFF86007d);
		} else {
			super.method_25420(stack);
		}
	}

	@Override
	public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
		method_25420(matrices);
		creditsList.method_25394(matrices, mouseX, mouseY, delta);
		super.method_25394(matrices, mouseX, mouseY, delta);
		method_27534(matrices, field_22793, method_25440(), field_22789 / 2, 33 / 2 - field_22793.field_2000 / 2, -1);
	}

	@Override
	public void method_25426() {
		creditsList = method_25429(new CreditsList(field_22787, field_22789, field_22790, field_22790 - 33 - 33, 33, 25));

		var back = method_25411(new class_4185(field_22789 / 2 - 75, field_22790 - 33 / 2 - 20 / 2, 150, 20, class_5244.field_24339, buttonWidget -> method_25419()));

		method_25411(new class_4185(6, back.field_22761, 100, 20, new class_2588("creditsBGM").method_27693(": ")
			.method_10852(new class_2588(AxolotlClient.config().creditsBGM.get() ? "options.on" : "options.off")),
			buttonWidget -> {
				AxolotlClient.config().creditsBGM.toggle();
				AxolotlClient.getInstance().getConfigManager().save();
				stopBGM();
				buttonWidget.method_25355(new class_2588("creditsBGM").method_27693(": ").method_10852(
					new class_2588(AxolotlClient.config().creditsBGM.get() ? "options.on" : "options.off")));
			}));
	}

	@Override
	public void method_25419() {
		field_22787.method_1507(parent);
		stopBGM();
	}

	@Override
	public void method_25393() {
		tickBGM();
	}

	public void tickBGM() {
		if (AxolotlClient.config().creditsBGM.get() && !field_22787.method_1483().method_4877(bgm)) {
			field_22787.method_1483().method_4873(bgm);
		}
	}

	private void stopBGM() {
		field_22787.method_1483().method_4870(bgm);
	}

	private class CreditsList extends class_4265<Entry> {

		public CreditsList(class_310 minecraftClient, int width, int screenHeight, int height, int top,
						   int entryHeight) {
			super(minecraftClient, width, height, top, top + height, entryHeight);

			method_25321(new SpacerTitle("- - - - - - " + class_1074.method_4662("contributors") + " - - - - - -"));
			Credits.getContributors().forEach(credit -> method_25321(new Credit(credit.getName(), credit.getThings())));

			method_25321(new SpacerTitle("- - - - - - " + class_1074.method_4662("other_people") + " - - - - - -"));
			Credits.getOtherPeople().forEach(credit -> method_25321(new Credit(credit.getName(), credit.getThings())));

			if (!externalModuleCredits.isEmpty()) {
				method_25321(new SpacerTitle("- - - - - - " + class_1074.method_4662("external_modules") + " - - - - - -"));
				externalModuleCredits.forEach((s, s2) -> method_25321(new Credit(s, s2)));
			}
		}
	}

	private abstract static class Entry extends class_4265.class_4266<Entry> {

	}

	private class Credit extends Entry {

		private final String name;
		private final String[] things;
		private final class_4185 c;

		public Credit(String name, String... things) {
			this.name = name;
			this.things = things;
			c = new class_4185(0, 0, 200, 20, class_2561.method_30163(name), buttonWidget -> field_22787.method_1507(new CreditOverlay(this))) {
				@Override
				public void method_25359(class_4587 graphics, int mouseX, int mouseY, float delta) {
					if (method_25367()) {
						RenderUtil.drawOutline(graphics, field_22760, field_22761, method_25368(), method_25364(), ClientColors.ERROR.toInt());
					}
					int i = this.field_22763 ? (method_25367() ? ClientColors.SELECTOR_RED.toInt() : -1) : 10526880;
					DrawUtil.method_27534(graphics, field_22793, method_25369(), field_22760 + field_22758 / 2, field_22761 + field_22759 / 2 - field_22793.field_2000 / 2, i | class_3532.method_15386(this.field_22765 * 255.0F) << 24);
				}
			};
		}

		@Override
		public void method_25343(class_4587 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX,
						   int mouseY, boolean hovered, float tickDelta) {
			c.field_22760 = x;
			c.field_22761 = y;
			c.method_25394(graphics, mouseX, mouseY, tickDelta);
		}

		@Override
		public List<? extends class_364> method_25396() {
			return List.of(c);
		}
	}

	private class CreditOverlay extends class_437 {
		private final Credit credit;
		private final List<Consumer<class_4587>> lines = new ArrayList<>();

		public CreditOverlay(Credit credit) {
			super(class_2561.method_30163(credit.name));
			this.credit = credit;
		}

		@Override
		public void method_25419() {
			field_22787.method_1507(CreditsScreen.this);
		}

		@Override
		public void method_25426() {
			int startY = 100;
			for (String t : credit.things) {
				int textWidth = field_22793.br$getWidth(t);
				if (t.startsWith("http")) {
					method_25411(new PlainTextButtonWidget(field_22789 / 2 - textWidth / 2, startY, textWidth, 12,
						(class_2561) AxoText.literal(t).br$color(ClientColors.SELECTOR_GREEN), btn -> {
						method_25430(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, t)));
					}, field_22793));
				} else {
					int y = startY;
					lines.add(m -> field_22793.method_1729(m, t, field_22789 / 2f - textWidth / 2f, y,
						ClientColors.SELECTOR_GREEN.toInt()));
				}
				startY += 12;
			}
			method_25411(new class_4185(field_22789 / 2 - 75, field_22790 - 33 / 2 - 10, 150, 20, class_5244.field_24339, buttonWidget -> method_25419()));
		}

		@Override
		public void method_25420(class_4587 graphics) {
			super.method_25420(graphics);
			RenderUtil.drawRectangle(graphics, 100, 50, field_22789 - 200, field_22790 - 100,
				ClientColors.DARK_GRAY.withAlpha(127));
			DrawUtil.outlineRect(graphics, 100, 50, field_22789 - 200, field_22790 - 100,
				ClientColors.BLACK.toInt());
		}

		@Override
		public void method_25394(class_4587 graphics, int mouseX, int mouseY, float delta) {
			super.method_25394(graphics, mouseX, mouseY, delta);
			DrawUtil.drawCenteredString(graphics, field_22793, credit.name,
				field_22789 / 2, 57, -16784327, true);
			lines.forEach(s -> s.accept(graphics));
		}

		@Override
		public void method_25393() {
			CreditsScreen.this.tickBGM();
		}
	}

	private class SpacerTitle extends Entry {

		private final String name;

		public SpacerTitle(String name) {
			this.name = name;
		}

		@Override
		public void method_25343(class_4587 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX,
						   int mouseY, boolean hovered, float tickDelta) {
			DrawUtil.drawCenteredString(graphics, field_22793, name, x + entryWidth / 2, y, -128374,
				true);
		}

		@Override
		public List<? extends class_364> method_25396() {
			return List.of();
		}
	}
}
