/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.config.screen;

import java.util.List;

import io.github.axolotlclient.config.profiles.Profiles;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;

public class ProfilesScreen extends class_437 {

	private final class_437 parent;

	public ProfilesScreen(class_437 parent) {
		super(new class_2588("profiles.configure.list"));
		this.parent = parent;
	}

	@Override
	public void method_25394(class_4587 graphics, int mouseX, int mouseY, float delta) {
		method_25420(graphics);
		super.method_25394(graphics, mouseX, mouseY, delta);
		method_27534(graphics, field_22793, method_25440(), field_22789 / 2, 33 / 2 - field_22793.field_2000 / 2, -1);
	}

	@Override
	protected void method_25426() {
		method_25429(new ProfilesList(field_22787, field_22789, field_22790, 33, field_22790 - 33, 25));

		method_25411(new class_4185(field_22789 / 2 - 75, field_22790 - 33 / 2 - 10, 150, 20, class_5244.field_24339, btn -> method_25419()));
	}

	@Override
	public void method_25419() {
		Profiles.getInstance().saveProfiles();
		//noinspection DataFlowIssue
		field_22787.method_1507(parent);
	}

	public class ProfilesList extends class_4265<ProfilesList.Entry> {
		private static final Entry SPACER = new SpacerEntry();
		private final Entry ADD = new NewEntry();

		public ProfilesList(class_310 minecraft, int width, int height, int top, int bottom, int itemHeight) {
			super(minecraft, width, height, top, bottom, itemHeight);
			reload();
		}

		public void reload() {
			method_25339();
			Profiles.getInstance().iterateAvailable(p -> method_25321(new ProfileEntry(p)));
			method_25321(SPACER);
			method_25321(ADD);
		}

		@Override
		public int method_25322() {
			return 340;
		}

		@Override
		protected int method_25329() {
			return method_25342() + method_25322() + 10;
		}

		@Environment(EnvType.CLIENT)
		public abstract static class Entry extends class_4265.class_4266<Entry> {

		}

		public static class SpacerEntry extends Entry {
			@Override
			public void method_25343(class_4587 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {

			}

			@Override
			public List<? extends class_364> method_25396() {
				return List.of();
			}
		}

		@Environment(EnvType.CLIENT)
		public class ProfileEntry extends Entry {
			private static final class_2561 EXPORT_BUTTON_TITLE = new class_2588("profiles.profile.export");
			private static final class_2561 CURRENT_TEXT = new class_2588("profiles.profile.current");
			private static final class_2561 LOAD_BUTTON_TITLE = new class_2588("profiles.profile.load");
			private static final class_2561 DUPLICATE_BUTTON_TITLE = new class_2588("profiles.profile.duplicate");
			private static final class_2561 REMOVE_BUTTON_TITLE = new class_2588("profiles.profile.remove");
			private final class_342 profileName;
			private final class_4185 exportButton, loadButton, duplicateButton, removeButton;
			private final Profiles.Profile profile;

			ProfileEntry(Profiles.Profile profile) {
				this.profile = profile;
				profileName = new class_342(field_22793, 0, 0, 150, 20, class_2585.field_24366);
				profileName.method_1852(profile.name());
				profileName.method_1863(profile::setName);
				exportButton = new class_4185(0, 0, 50, 20, EXPORT_BUTTON_TITLE, btn ->
					Profiles.getInstance().exportProfile(profile));
				loadButton = new class_4185(0, 0, 50, 20, LOAD_BUTTON_TITLE, btn ->
					Profiles.getInstance().switchTo(profile));
				duplicateButton = new class_4185(0, 0, 50, 20, DUPLICATE_BUTTON_TITLE, b -> {
					var dup = Profiles.getInstance().duplicate(profile);
					double d = (double) Math.max(0, method_25317() - (field_19086 - field_19085 - 4)) - ProfilesList.this.method_25341();
					ProfilesList.this.method_25396().add(ProfilesList.this.method_25396().indexOf(ProfileEntry.this) + 1, new ProfileEntry(dup));
					ProfilesList.this.method_25307(Math.max(0, method_25317() - (field_19086 - field_19085 - 4)) - d);
				});

				this.removeButton = new class_4185(0, 0, 50, 20, REMOVE_BUTTON_TITLE, b -> {
					method_25330(this);
					Profiles.getInstance().remove(profile);
					method_25307(method_25341());
				});
			}

			@Override
			public void method_25343(class_4587 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
				int i = method_25329() - removeButton.method_25368() - 4;
				int j = top - 2;
				this.removeButton.field_22760 = i;
				removeButton.field_22761 = j;
				this.removeButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);

				i -= duplicateButton.method_25368();
				duplicateButton.field_22760 = i;
				duplicateButton.field_22761 = j;
				duplicateButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);

				boolean current = Profiles.getInstance().getCurrent() == profile;
				loadButton.method_25355(current ? CURRENT_TEXT : LOAD_BUTTON_TITLE);
				loadButton.field_22763 = removeButton.field_22763 = !current;
				i -= loadButton.method_25368();
				this.loadButton.field_22760 = i;
				loadButton.field_22761 = j;
				this.loadButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
				i -= exportButton.method_25368();
				exportButton.field_22760 = i;
				exportButton.field_22761 = j;
				exportButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
				profileName.method_25358(i - left - 4);
				profileName.field_22760 = left;
				profileName.field_22761 = j;
				profileName.method_25394(guiGraphics, mouseX, mouseY, partialTick);
			}

			@Override
			public List<? extends class_364> method_25396() {
				return List.of(profileName, this.loadButton, duplicateButton, removeButton);
			}
		}

		public class NewEntry extends Entry {

			private final class_4185 addButton, importButton;

			public NewEntry() {
				this.addButton = new class_4185(0, 0, 150, 20, new class_2588("profiles.profile.add"), button -> {
					int i = ProfilesList.this.method_25396().indexOf(this);
					ProfilesList.this.method_25396().add(Math.max(i - 1, 0), new ProfileEntry(Profiles.getInstance().newProfile(class_1074.method_4662("profiles.profile.default_new_name"))));
					Profiles.getInstance().saveProfiles();
					method_25307(Math.max(0, method_25317() - (field_19086 - field_19085 - 4)));
				});
				this.importButton = new class_4185(0, 0, 150, 20, new class_2588("profiles.profile.import"), btn ->
					Profiles.getInstance().importProfiles().thenRun(ProfilesList.this::reload));
			}

			@Override
			public void method_25343(class_4587 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
				int i = method_25329() - width / 2 - 10 - addButton.method_25368() + 2;
				int j = top - 2;
				this.addButton.field_22760 = i;
				addButton.field_22761 = j;
				this.addButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
				this.importButton.field_22760 = addButton.field_22760 + addButton.method_25368() + 2;
				this.importButton.field_22761 = j;
				this.importButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
			}

			@Override
			public List<? extends class_364> method_25396() {
				return List.of(addButton, importButton);
			}
		}
	}
}
