/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.api.requests.UserRequest;
import io.github.axolotlclient.modules.hypixel.LevelHead;
import io.github.axolotlclient.modules.hypixel.NickHider;
import io.github.axolotlclient.modules.hypixel.bedwars.BedwarsMod;
import io.github.axolotlclient.util.ClientColors;
import io.github.axolotlclient.util.Util;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_742;
import net.minecraft.class_897;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_897.class)
public abstract class EntityRendererMixin<T extends class_1297> {

	@Inject(method = "renderLabelIfPresent", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/font/TextRenderer;draw(Lnet/minecraft/text/Text;FFIZLnet/minecraft/util/math/Matrix4f;Lnet/minecraft/client/render/VertexConsumerProvider;ZII)I", ordinal = 0))
	public void axolotlclient$addBadges(T entity, class_2561 text, class_4587 matrices, class_4597 vertexConsumers, int light,
										CallbackInfo ci) {
		if (entity instanceof class_742 && text.equals(entity.method_5476())) {
			if (!entity.method_21751()) {
				if (AxolotlClient.config().showBadges.get() && UserRequest.getOnline(entity.method_5667().toString())) {
					RenderSystem.enableDepthTest();
					class_310.method_1551().method_1531().method_22813(AxolotlClient.badgeIcon);

					assert class_310.method_1551().field_1724 != null;
					int x = -(class_310.method_1551().field_1772
						.method_1727(
							entity.method_5667() == class_310.method_1551().field_1724.method_5667()
								? (NickHider.getInstance().hideOwnName.get()
								? NickHider.getInstance().hiddenNameSelf.get()
								: class_268.method_1142(entity.method_5781(), entity.method_5477())
								.getString())
								: (NickHider.getInstance().hideOtherNames.get()
								? NickHider.getInstance().hiddenNameOthers.get()
								: class_268.method_1142(entity.method_5781(), entity.method_5477())
								.getString()))
						/ 2
						+ (AxolotlClient.config().customBadge.get() ? class_310.method_1551().field_1772
						.method_1727(" " + class_124.method_539(AxolotlClient.config().badgeText.get())) : 10));

					RenderSystem.color4f(1, 1, 1, 1);

					if (AxolotlClient.config().customBadge.get()) {
						class_2561 badgeText = Util.formatFromCodes(AxolotlClient.config().badgeText.get());
						if (AxolotlClient.config().useShadows.get()) {
							class_310.method_1551().field_1772.method_30881(matrices, badgeText, x + 6, 0, -1);
						} else {
							class_310.method_1551().field_1772.method_30883(matrices, badgeText, x + 6, 0, -1);
						}
					} else {
						class_332.method_25290(matrices, x, 0, 0, 0, 8, 8, 8, 8);
					}
					RenderSystem.disableDepthTest();
				}
			}
		}
	}

	@ModifyArg(method = "renderLabelIfPresent", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/font/TextRenderer;draw(Lnet/minecraft/text/Text;FFIZLnet/minecraft/util/math/Matrix4f;Lnet/minecraft/client/render/VertexConsumerProvider;ZII)I", ordinal = 0), index = 8)
	public int axolotlclient$bgColor(int color) {
		if (AxolotlClient.config().nametagBackground.get()) {
			return color;
		} else {
			return 0;
		}
	}

	@ModifyArg(method = "renderLabelIfPresent", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/font/TextRenderer;draw(Lnet/minecraft/text/Text;FFIZLnet/minecraft/util/math/Matrix4f;Lnet/minecraft/client/render/VertexConsumerProvider;ZII)I", ordinal = 1), index = 4)
	public boolean axolotlclient$enableShadows(boolean shadow) {
		return AxolotlClient.config().useShadows.get();
	}

	@Inject(method = "renderLabelIfPresent", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/font/TextRenderer;draw(Lnet/minecraft/text/Text;FFIZLnet/minecraft/util/math/Matrix4f;Lnet/minecraft/client/render/VertexConsumerProvider;ZII)I", ordinal = 1))
	public void axolotlclient$addLevel(T entity, class_2561 string, class_4587 matrices, class_4597 vertexConsumers, int light,
									   CallbackInfo ci, @Local(ordinal = 2) int bgColor) {
		if (entity instanceof class_742 && string.equals(entity.method_5476())) {
			if (class_310.method_1551().method_1558() != null
				&& class_310.method_1551().method_1558().field_3761.contains("hypixel.net")) {
				class_327 textRenderer = class_310.method_1551().field_1772;
				if (BedwarsMod.getInstance().isEnabled() &&
					BedwarsMod.getInstance().inGame() &&
					BedwarsMod.getInstance().bedwarsLevelHead.get()) {
					String text = BedwarsMod.getInstance().getGame().get().getLevelHead((class_742) entity);
					if (text != null) {
						float x = -textRenderer.method_1727(text) / 2F;
						float y = string.getString().contains("deadmau5") ? -20 : -10;

						if (LevelHead.getInstance().background.get()) {
							y -= 2;
						}

						class_1159 matrix4f = matrices.method_23760().method_23761();
						class_310.method_1551().field_1772.method_27521(text, x, y,
							ClientColors.ARGB.color(0x20, LevelHead.getInstance().textColor.get().toInt()), false,
							matrix4f, vertexConsumers, true, LevelHead.getInstance().background.get() ? bgColor : 0,
							light);
						class_310.method_1551().field_1772.method_27521(text, x, y,
							LevelHead.getInstance().textColor.get().toInt(), AxolotlClient.config().useShadows.get(),
							matrix4f, vertexConsumers, false, 0,
							light);
					}
				} else if (LevelHead.getInstance().enabled.get()) {
					String text = LevelHead.getInstance().getDisplayString(entity.method_5667().toString());

					float x = -textRenderer.method_1727(text) / 2F;
					float y = string.getString().contains("deadmau5") ? -20 : -10;

					if (LevelHead.getInstance().background.get()) {
						y -= 2;
					}

					class_1159 matrix4f = matrices.method_23760().method_23761();
					class_310.method_1551().field_1772.method_27521(text, x, y,
						ClientColors.ARGB.color(0x20, LevelHead.getInstance().textColor.get().toInt()), false,
						matrix4f, vertexConsumers, true, LevelHead.getInstance().background.get() ? bgColor : 0,
						light);
					class_310.method_1551().field_1772.method_27521(text, x, y,
						LevelHead.getInstance().textColor.get().toInt(), AxolotlClient.config().useShadows.get(),
						matrix4f, vertexConsumers, false, 0,
						light);
				}
			}
		}
	}
}
