/*
 * Copyright © 2023 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import io.github.axolotlclient.modules.hud.HudManager;
import io.github.axolotlclient.modules.hud.gui.hud.IconHud;
import io.github.axolotlclient.modules.scrollableTooltips.ScrollableTooltips;
import net.minecraft.class_1735;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_465.class)
public abstract class HandledScreenMixin {

	@Shadow
	@Nullable
	protected class_1735 focusedSlot;
	@Unique
	private class_1735 cachedSlot;

	@Inject(method = "drawMouseoverTooltip", at = @At("HEAD"))
	public void axolotlclient$resetScrollOnChange(class_4587 matrices, int x, int y, CallbackInfo ci) {
		if (ScrollableTooltips.getInstance().enabled.get() && cachedSlot != focusedSlot) {
			cachedSlot = focusedSlot;
			ScrollableTooltips.getInstance().resetScroll();
		}
	}

	@Inject(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/ingame/HandledScreen;drawBackground(Lnet/minecraft/client/util/math/MatrixStack;FII)V"))
	private void renderIcon(class_4587 matrices, int mouseX, int mouseY, float delta, CallbackInfo ci) {
		var hud = (IconHud) HudManager.getInstance().get(IconHud.ID);
		if (hud != null && hud.isEnabled()) {
			hud.renderInGui(matrices, delta);
		}
	}
}
