/*
 * Copyright © 2023 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import java.util.Random;
import net.minecraft.class_1087;
import net.minecraft.class_1160;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_809;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_916;
import net.minecraft.class_918;
import io.github.axolotlclient.AxolotlClient;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(class_916.class)
public abstract class ItemEntityRendererMixin extends class_897<class_1542> {

	@Shadow
	@Final
	private Random random;

	@Shadow
	@Final
	private class_918 itemRenderer;

	protected ItemEntityRendererMixin(class_898 dispatcher) {
		super(dispatcher);
	}

	@Inject(method = "render(Lnet/minecraft/entity/ItemEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/util/math/MatrixStack;translate(DDD)V"), locals = LocalCapture.CAPTURE_FAILHARD, cancellable = true)
	private void minimalItemPhysics(class_1542 itemEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, CallbackInfo ci, class_1799 itemStack, int j, class_1087 bakedModel, boolean bl, int k, float h, float l, float m) {
		if (AxolotlClient.config().flatItems.get()) {
			matrixStack.method_22907(class_1160.field_20707.method_23214(itemEntity.method_5695(0)));
			matrixStack.method_22907(class_1160.field_20703.method_23214(90));
			if (!itemEntity.method_24828()) {
				itemEntity.field_5965 = (itemEntity.method_5695(0) - 5);
				matrixStack.method_22907(class_1160.field_20703.method_23214(itemEntity.method_5695(0)));
				matrixStack.method_22907(class_1160.field_20705.method_23214(itemEntity.method_5695(0)));
				matrixStack.method_22907(class_1160.field_20707.method_23214(itemEntity.method_5695(0)));
			}
			float o = bakedModel.method_4709().field_4303.field_4285.method_4943();
			float p = bakedModel.method_4709().field_4303.field_4285.method_4945();
			float q = bakedModel.method_4709().field_4303.field_4285.method_4947();
			for (int u = 0; u < k; ++u) {
				matrixStack.method_22903();
				if (u > 0) {
					if (bl) {
						float s = (this.random.nextFloat() * 2.0F - 1.0F) * 0.15F;
						float t = (this.random.nextFloat() * 2.0F - 1.0F) * 0.15F;
						float v = (this.random.nextFloat() * 2.0F - 1.0F) * 0.15F;
						matrixStack.method_22904(s, t, v);
					} else {
						float s = (this.random.nextFloat() * 2.0F - 1.0F) * 0.15F * 0.5F;
						float t = (this.random.nextFloat() * 2.0F - 1.0F) * 0.15F * 0.5F;
						matrixStack.method_22904(s, t, 0.0F);
					}
				}

				this.itemRenderer
					.method_23179(itemStack, class_809.class_811.field_4318, false, matrixStack, vertexConsumerProvider, i, class_4608.field_21444, bakedModel);
				matrixStack.method_22909();
				if (!bl) {
					matrixStack.method_22904(0.0F * o, 0.0F * p, 0.09375F * q);
				}
			}

			matrixStack.method_22909();
			super.method_3936(itemEntity, f, g, matrixStack, vertexConsumerProvider, i);
			ci.cancel();
		}
	}
}
