/*
 * Copyright © 2023 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.modules.hud.gui.hud.PlayerHud;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_583;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_922;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_922.class)
public abstract class LivingEntityRendererMixin<T extends class_1309, M extends class_583<T>>
	extends class_897<T> implements class_3883<T, M> {

	protected LivingEntityRendererMixin(class_898 dispatcher) {
		super(dispatcher);
	}

	@Inject(method = "hasLabel(Lnet/minecraft/entity/LivingEntity;)Z", at = @At("HEAD"), cancellable = true)
	private void axolotlclient$showOwnNametag(T livingEntity, CallbackInfoReturnable<Boolean> cir) {
		if (AxolotlClient.config().showOwnNametag.get()
			&& livingEntity.method_5628() == class_310.method_1551().field_1724.method_5628()
			&& !PlayerHud.isCurrentlyRendering()) {
			cir.setReturnValue(true);
		}
	}
}
