/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import java.util.Collections;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_355;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_640;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.api.requests.UserRequest;
import io.github.axolotlclient.modules.hypixel.NickHider;
import io.github.axolotlclient.modules.hypixel.bedwars.BedwarsGame;
import io.github.axolotlclient.modules.hypixel.bedwars.BedwarsMod;
import io.github.axolotlclient.modules.hypixel.bedwars.BedwarsPlayer;
import io.github.axolotlclient.modules.tablist.Tablist;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_355.class)
public abstract class PlayerListHudMixin {

	@Shadow
	private class_2561 header;
	@Shadow
	private class_2561 footer;

	@Shadow
	@Final
	private class_310 client;

	@WrapMethod(method = "getPlayerName")
	private class_2561 nickHider(class_640 entry, Operation<class_2561> original) {
		var orig = original.call(entry);
		if (client.field_1724 == null) {
			return orig;
		}
		if (entry.method_2966().equals(client.field_1724.method_7334()) && NickHider.getInstance().hideOwnName.get()) {
			return (class_2561) NickHider.getInstance().editComponent(orig, entry.method_2966().getName(), NickHider.getInstance().hiddenNameSelf.get());
		} else if (!entry.method_2966().equals(client.field_1724.method_7334()) &&
			NickHider.getInstance().hideOtherNames.get()) {
			return (class_2561) NickHider.getInstance().editComponent(orig, entry.method_2966().getName(), NickHider.getInstance().hiddenNameOthers.get());
		}
		return orig;
	}

	@WrapOperation(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/font/TextRenderer;getWidth(Lnet/minecraft/text/StringVisitable;)I", ordinal = 0))
	private int axolotlclient$moveName(class_327 instance, class_5348 text, Operation<Integer> original, @Local class_640 entry) {
		var width = original.call(instance, text);
		if (AxolotlClient.config().showBadges.get() && UserRequest.getOnline(entry.method_2966().getId().toString())) {
			width += 10;
		}
		if (Tablist.getInstance().numericalPing.get())
			width += (instance.method_1727(String.valueOf(entry.method_2959())) - 10);
		return width;
	}

	@Redirect(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/font/TextRenderer;drawWithShadow(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/text/Text;FFI)I"))
	public int axolotlclient$moveName2(class_327 instance, class_4587 matrices, class_2561 text, float x, float y, int color, @Local class_640 entry) {
		if (AxolotlClient.config().showBadges.get() && UserRequest.getOnline(entry.method_2966().getId().toString())) {
			class_310.method_1551().method_1531().method_22813(AxolotlClient.badgeIcon);
			RenderSystem.color4f(1, 1, 1, 1);
			class_332.method_25293(matrices, (int) x, (int) y, 8, 8, 0, 0, 8, 8, 8, 8);
			x += 9;
		}
		return instance.method_30881(matrices, text, x, y, color);
	}

	@Inject(method = "renderLatencyIcon", at = @At("HEAD"), cancellable = true)
	private void axolotlclient$numericalPing(class_4587 matrices, int width, int x, int y, class_640 entry, CallbackInfo ci) {
		if (BedwarsMod.getInstance().isEnabled() && BedwarsMod.getInstance().blockLatencyIcon() && (BedwarsMod.getInstance().isWaiting() || BedwarsMod.getInstance().inGame())) {
			ci.cancel();
		} else if (Tablist.getInstance().renderNumericPing(matrices, width, x, y, entry)) {
			ci.cancel();
		}
	}

	@Redirect(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/MinecraftClient;isInSingleplayer()Z"))
	private boolean showPlayerHeads$1(class_310 instance) {
		if (Tablist.getInstance().showPlayerHeads.get()) {
			return instance.method_1542();
		}
		return false;
	}

	@Redirect(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/ClientConnection;isEncrypted()Z"))
	private boolean axolotlclient$showPlayerHeads$1(class_2535 instance) {
		if (Tablist.getInstance().showPlayerHeads.get()) {
			return instance.method_10771();
		}
		return false;
	}

	@Inject(method = "render", at = @At(value = "FIELD", target = "Lnet/minecraft/client/gui/hud/PlayerListHud;header:Lnet/minecraft/text/Text;"))
	private void axolotlclient$setRenderHeaderFooter(class_4587 matrices, int scaledWindowWidth, class_269 scoreboard, class_266 objective, CallbackInfo ci) {
		if (!Tablist.getInstance().showHeader.get()) {
			header = null;
		}
		if (!Tablist.getInstance().showFooter.get()) {
			footer = null;
		}
	}

	@Redirect(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerEntity;isPartVisible(Lnet/minecraft/client/render/entity/PlayerModelPart;)Z", ordinal = 1))
	private boolean axolotlclient$alwaysShowHeadLayer(class_1657 instance, class_1664 modelPart) {
		return Tablist.getInstance().alwaysShowHeadLayer.get() || instance.method_7348(modelPart);
	}

	@Inject(
		method = "renderScoreboardObjective",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/client/font/TextRenderer;drawWithShadow(Lnet/minecraft/client/util/math/MatrixStack;Ljava/lang/String;FFI)I",
			ordinal = 1
		),
		cancellable = true
	)
	private void axolotlclient$renderCustomScoreboardObjective(
		class_266 objective, int y, String player, int startX, int endX,
		class_640 playerEntry, class_4587 matrices, CallbackInfo ci
	) {
		if (!BedwarsMod.getInstance().isEnabled()) {
			return;
		}

		BedwarsGame game = BedwarsMod.getInstance().getGame().orElse(null);
		if (game == null) {
			return;
		}

		game.renderCustomScoreboardObjective(matrices, playerEntry.method_2966().getName(), objective.method_1117().method_1180(player, objective).method_1126(), y, endX);

		ci.cancel();
	}

	@ModifyVariable(
		method = "render",
		at = @At(
			value = "STORE"
		),
		ordinal = 7
	)
	public int axolotlclient$changeWidth(int value) {
		if (BedwarsMod.getInstance().isEnabled() && BedwarsMod.getInstance().blockLatencyIcon() && (BedwarsMod.getInstance().isWaiting() || BedwarsMod.getInstance().inGame())) {
			value -= 9;
		}
		if (BedwarsMod.getInstance().isEnabled() && BedwarsMod.getInstance().isWaiting()) {
			value += 20;
		}
		return value;
	}

	@Inject(method = "getPlayerName", at = @At("HEAD"), cancellable = true)
	public void axolotlclient$getPlayerName(class_640 playerEntry, CallbackInfoReturnable<class_2561> cir) {
		if (!BedwarsMod.getInstance().isEnabled()) {
			return;
		}
		BedwarsGame game = BedwarsMod.getInstance().getGame().orElse(null);
		if (game == null || !game.isStarted()) {
			return;
		}
		BedwarsPlayer player = game.getPlayer(playerEntry.method_2966().getName()).orElse(null);
		if (player == null) {
			return;
		}
		cir.setReturnValue(class_2561.method_30163(player.getTabListDisplay()));
	}

	@SuppressWarnings({"unchecked", "rawtypes"})
	@ModifyVariable(method = "render", at = @At(value = "INVOKE_ASSIGN", target = "Lcom/google/common/collect/Ordering;sortedCopy(Ljava/lang/Iterable;)Ljava/util/List;", remap = false))
	public List<class_640> axolotlclient$overrideSortedPlayers(List<class_640> original) {
		if (!BedwarsMod.getInstance().inGame()) {
			return original;
		}
		List<?> players = BedwarsMod.getInstance().getGame().orElseThrow().getTabPlayerList(Collections.unmodifiableList(original));
		if (players == null) {
			return original;
		}
		return (List) players;
	}

	@Inject(method = "setHeader", at = @At("HEAD"), cancellable = true)
	public void axolotlclient$changeHeader(class_2561 header, CallbackInfo ci) {
		if (!BedwarsMod.getInstance().inGame()) {
			return;
		}
		this.header = (class_2561) BedwarsMod.getInstance().getGame().orElseThrow().getTopBarText();
		ci.cancel();
	}

	@Inject(method = "setFooter", at = @At("HEAD"), cancellable = true)
	public void axolotlclient$changeFooter(class_2561 footer, CallbackInfo ci) {
		if (!BedwarsMod.getInstance().inGame()) {
			return;
		}
		this.footer = (class_2561) BedwarsMod.getInstance().getGame().orElseThrow().getBottomBarText();
		ci.cancel();
	}

	@WrapOperation(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/hud/PlayerListHud;fill(Lnet/minecraft/client/util/math/MatrixStack;IIIII)V"), slice = @Slice(to = @At(value = "INVOKE", target = "Lnet/minecraft/client/options/GameOptions;getTextBackgroundColor(I)I")))
	private void modifyBackground(class_4587 stack, int x1, int y1, int x2, int y2, int color, Operation<Void> original) {
		var tablist = Tablist.getInstance();
		if (!tablist.backgroundEnabled.get()) {
			return;
		}
		if (tablist.customBackgroundColor.get()) {
			original.call(stack, x1, y1, x2, y2, tablist.backgroundColor.get().toInt());
			return;
		}
		original.call(stack, x1, y1, x2, y2, color);
	}

	@WrapOperation(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/hud/PlayerListHud;fill(Lnet/minecraft/client/util/math/MatrixStack;IIIII)V"), slice = @Slice(from = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/hud/PlayerListHud;renderLatencyIcon(Lnet/minecraft/client/util/math/MatrixStack;IIILnet/minecraft/client/network/PlayerListEntry;)V")))
	private void modifyBackground$2(class_4587 stack, int x1, int y1, int x2, int y2, int color, Operation<Void> original) {
		modifyBackground(stack, x1, y1, x2, y2, color, original);
	}
}
