/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin.api;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.multiplayer.FriendsMultiplayerScreen;
import io.github.axolotlclient.api.requests.FriendRequest;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_4185;
import net.minecraft.class_4267;
import net.minecraft.class_437;
import net.minecraft.class_500;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(class_500.class)
public abstract class JoinMulitplayerScreenMixin extends class_437 {

	@Shadow
	@Final
	private class_437 parent;
	@Unique
	private static final boolean WORLD_HOST_INSTALLED = FabricLoader.getInstance().isModLoaded("world-host");

	protected JoinMulitplayerScreenMixin(class_2561 title) {
		super(title);
	}

	@Inject(method = "init", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/multiplayer/MultiplayerScreen;addButton(Lnet/minecraft/client/gui/widget/AbstractButtonWidget;)Lnet/minecraft/client/gui/widget/AbstractButtonWidget;", ordinal = 0))
	private void addFriendsMultiplayerScreenButtons(CallbackInfo ci) {
		if (API.getInstance().isAuthenticated() && !WORLD_HOST_INSTALLED) {
			method_25411(new class_4185(this.field_22789 / 2 - 102, 32, 100, 20, new class_2588("api.servers"), button -> {

			})).field_22763 = false;
			class_4185 friendsCountButton = method_25411(new class_4185(field_22789 / 2 + 2, 32, 100, 20,
				new class_2588("api.servers.friends", "..."), button ->
				field_22787.method_1507(new FriendsMultiplayerScreen(this.parent))));
			FriendRequest.getInstance().getOnlineFriendCount().thenAccept(count -> friendsCountButton.method_25355(new class_2588("api.servers.friends", count)));
		}
	}

	@WrapOperation(method = "init", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/multiplayer/MultiplayerServerListWidget;updateSize(IIII)V"))
	private void increaseHeaderSize(class_4267 instance, int width, int height, int top, int bottom, Operation<Void> original) {
		if (API.getInstance().isAuthenticated() && !WORLD_HOST_INSTALLED) {
			top += -32 + 60;
		}
		original.call(instance, width, height, top, bottom);
	}

	@ModifyArgs(method = "init", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/multiplayer/MultiplayerServerListWidget;<init>(Lnet/minecraft/client/gui/screen/multiplayer/MultiplayerScreen;Lnet/minecraft/client/MinecraftClient;IIIII)V"))
	private void increaseHeaderSize$2(Args args) {
		if (API.getInstance().isAuthenticated() && !WORLD_HOST_INSTALLED) {
			args.set(4, ((Integer) args.get(4)) - 32 + 60);
		}
	}

	@ModifyArg(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/multiplayer/MultiplayerScreen;drawCenteredText(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Text;III)V"), index = 4)
	private int shiftTitle(int par3) {
		if (API.getInstance().isAuthenticated() && !WORLD_HOST_INSTALLED) {
			return 15;
		}
		return par3;
	}
}
