/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.auth;

import java.util.List;
import com.mojang.blaze3d.systems.RenderSystem;
import lombok.Getter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4280;
import net.minecraft.class_4493;
import net.minecraft.class_4587;

public class AccountsListWidget extends class_4280<AccountsListWidget.Entry> {

	private final AccountsScreen screen;

	public AccountsListWidget(AccountsScreen screen, class_310 client, int width, int height, int top, int bottom, int entryHeight) {
		super(client, width, height, top, bottom, entryHeight);
		this.screen = screen;
	}

	public void setAccounts(List<Account> accounts) {
		accounts.forEach(account -> method_25321(new Entry(screen, account)));
	}

	@Override
	public int method_25322() {
		return super.method_25322() + 85;
	}

	@Override
	protected int method_25329() {
		return super.method_25329() + 30;
	}

	@Override
	protected boolean method_25316() {
		return this.screen.method_25399() == this;
	}

	@Environment(EnvType.CLIENT)
	public static class Entry extends class_4280.class_4281<Entry> {

		private static final class_2960 checkmark = new class_2960("axolotlclient", "textures/check.png");
		private static final class_2960 warningSign = new class_2960("axolotlclient", "textures/warning.png");

		private final AccountsScreen screen;
		@Getter
		private final Account account;
		private final class_310 client;
		private long time;

		public Entry(AccountsScreen screen, Account account) {
			this.screen = screen;
			this.account = account;
			this.client = class_310.method_1551();
		}

		@Override
		public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
			//noinspection deprecation
			class_4493.method_22000(1, 1, 1, 1);
			if (Auth.getInstance().getCurrent().equals(account)) {
				client.method_1531().method_22813(checkmark);
				method_25290(matrices, x - 35, y + 1, 0, 0, 32, 32, 32, 32);
			} else if (account.isExpired()) {
				client.method_1531().method_22813(warningSign);
				method_25290(matrices, x - 35, y + 1, 0, 0, 32, 32, 32, 32);
			}
			client.method_1531().method_22813(Auth.getInstance().getSkinTexture(account));
			RenderSystem.enableBlend();
			method_25293(matrices, x - 1, y - 1, 33, 33, 8, 8, 8, 8, 64, 64);
			method_25293(matrices, x - 1, y - 1, 33, 33, 40, 8, 8, 8, 64, 64);
			RenderSystem.disableBlend();

			client.field_1772.method_1729(matrices, account.getName(), x + 3 + 33, y + 1, -1);
			client.field_1772.method_1729(matrices, account.getUuid(), x + 3 + 33, y + 12, 8421504);
		}

		@Override
		public boolean method_25402(double mouseX, double mouseY, int button) {
			this.screen.select(this);
			if (class_156.method_658() - this.time < 250L && client.field_1687 == null) {
				if (!getAccount().equals(Auth.getInstance().getCurrent())) {
					screen.select(null);
					Auth.getInstance().login(account);
				}
			}

			this.time = class_156.method_658();
			return false;
		}

	}
}
