/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.auth;

import io.github.axolotlclient.modules.auth.skin.SkinManagementScreen;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;

public class AccountsScreen extends class_437 {
	private final class_437 parent;
	protected AccountsListWidget accountsListWidget;
	private class_4185 loginButton;
	private class_4185 deleteButton;
	private class_4185 refreshButton;
	private class_4185 skinsButton;

	public AccountsScreen(class_437 currentScreen) {
		super(new class_2588("accounts"));
		this.parent = currentScreen;
	}

	@Override
	public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
		this.method_25420(matrices);
		this.accountsListWidget.method_25394(matrices, mouseX, mouseY, delta);
		method_27534(matrices, this.field_22793, this.field_22785, this.field_22789 / 2, 20, 16777215);
		super.method_25394(matrices, mouseX, mouseY, delta);
	}

	@Override
	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		if (super.method_25404(keyCode, scanCode, modifiers)) {
			return true;
		} else if (keyCode == 294) {
			this.refresh();
			return true;
		} else if (this.accountsListWidget.method_25334() != null) {
			if (keyCode != 257 && keyCode != 335) {
				return this.accountsListWidget.method_25404(keyCode, scanCode, modifiers);
			} else {
				this.login();
				return true;
			}
		} else {
			return false;
		}
	}

	@Override
	public void method_25426() {

		accountsListWidget = new AccountsListWidget(this, field_22787, field_22789, field_22790, 32, field_22790 - 64, 35);
		method_25429(accountsListWidget);

		accountsListWidget.setAccounts(Auth.getInstance().getAccounts());

		method_25411(loginButton = new class_4185(this.field_22789 / 2 - 154, this.field_22790 - 52, 100, 20, new class_2588("auth.login"),
			buttonWidget -> login()));

		method_25411(skinsButton = new class_4185(this.field_22789 / 2 - 50, this.field_22790 - 52, 100, 20, new class_2588("skins.manage"),
			btn -> field_22787.method_1507(new SkinManagementScreen(
				this, accountsListWidget.method_25334().getAccount()))));

		this.method_25411(new class_4185(this.field_22789 / 2 + 4 + 50, this.field_22790 - 52, 100, 20, new class_2588("auth.add"),
			button -> {
				if (!Auth.getInstance().allowOfflineAccounts()) {
					initMSAuth();
				} else {
					field_22787.method_1507(new class_410(result -> {
						if (!result) {
							field_22787.method_1507(this);
							initMSAuth();
						} else {
							field_22787.method_1507(new AddOfflineScreen(this));
						}
					}, new class_2588("auth.add.choose"), class_2585.field_24366, new class_2588("auth.add.offline"), new class_2588("auth.add.ms")));
				}
			}));

		this.deleteButton = this.method_25411(new class_4185(this.field_22789 / 2 - 50, this.field_22790 - 28, 100, 20, new class_2588("selectServer.delete"), button -> {
			AccountsListWidget.Entry entry = this.accountsListWidget.method_25334();
			if (entry != null) {
				button.field_22763 = false;
				Auth.getInstance().removeAccount(entry.getAccount());
				refresh();
			}
		}));


		this.method_25411(refreshButton = new class_4185(this.field_22789 / 2 - 154, this.field_22790 - 28, 100, 20,
			new class_2588("auth.refresh"), button -> refreshAccount()));

		this.method_25411(new class_4185(this.field_22789 / 2 + 4 + 50, this.field_22790 - 28, 100, 20,
			class_5244.field_24339, button -> this.field_22787.method_1507(this.parent)));
		updateButtonActivationStates();
	}

	@Override
	public void method_25432() {
		Auth.getInstance().save();
	}

	private void initMSAuth() {
		Auth.getInstance().getMsApi().startDeviceAuth().thenRun(() -> client.execute(this::refresh));
	}

	private void refreshAccount() {
		refreshButton.field_22763 = false;
		AccountsListWidget.Entry entry = accountsListWidget.method_25334();
		if (entry != null) {
			entry.getAccount().refresh(Auth.getInstance().getMsApi());
		}
	}

	private void updateButtonActivationStates() {
		AccountsListWidget.Entry entry = accountsListWidget.method_25334();
		if (field_22787.field_1687 == null && entry != null) {
			loginButton.field_22763 = entry.getAccount().isExpired() || !entry.getAccount().equals(Auth.getInstance().getCurrent());
			refreshButton.field_22763 = skinsButton.field_22763 = !entry.getAccount().isOffline();
			deleteButton.field_22763 = true;
		} else {
			loginButton.field_22763 = deleteButton.field_22763 = refreshButton.field_22763 = skinsButton.field_22763 = false;
		}
	}

	private void refresh() {
		this.field_22787.method_1507(new AccountsScreen(this.parent));
	}

	private void login() {
		loginButton.field_22763 = false;
		AccountsListWidget.Entry entry = accountsListWidget.method_25334();
		if (entry != null) {
			Auth.getInstance().login(entry.getAccount());
		}
	}

	public void select(AccountsListWidget.Entry entry) {
		this.accountsListWidget.method_25313(entry);
		this.updateButtonActivationStates();
	}
}
