/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.auth;

import java.util.UUID;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;

public class AddOfflineScreen extends class_437 {

	private final class_437 parent;
	private class_342 nameInput;

	public AddOfflineScreen(class_437 parent) {
		super(new class_2588("auth.add.offline"));
		this.parent = parent;
	}

	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		return super.method_25402(mouseX, mouseY, button) || nameInput.method_25402(mouseX, mouseY, button);
	}

	@Override
	public void method_25394(class_4587 matrices, int i, int j, float f) {
		method_25420(matrices);
		super.method_25394(matrices, i, j, f);
		field_22793.method_30881(matrices, new class_2588("auth.add.offline.name"), field_22789 / 2F - 100, field_22790 / 2f - 20, -1);
		method_27534(matrices, this.field_22793, this.field_22785, this.field_22789 / 2, 20, 16777215);
		nameInput.method_25394(matrices, i, j, f);
	}

	@Override
	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		return super.method_25404(keyCode, scanCode, modifiers) || nameInput.method_25404(keyCode, scanCode, modifiers);
	}

	@Override
	public void method_25426() {
		method_25429(nameInput = new class_342(field_22793, field_22789 / 2 - 100, field_22790 / 2 - 10, 200, 20, class_2585.field_24366));

		method_25411(new class_4185(field_22789 / 2 - 155, field_22790 - 50, 150, 20, class_5244.field_24335, button -> field_22787.method_1507(parent)));
		method_25411(new class_4185(field_22789 / 2 + 5, field_22790 - 50, 150, 20, class_5244.field_24334, button -> {
			Auth.getInstance().addAccount(new Account(nameInput.method_1882(), UUID.randomUUID().toString(), Account.OFFLINE_TOKEN));
			field_22787.method_1507(parent);
		}));
	}

	@Override
	public void method_25393() {
		nameInput.method_1865();
	}
}
