/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.auth.skin;

import java.util.function.Consumer;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.client.render.*;
import org.jetbrains.annotations.Nullable;

public class SkinRenderer {
	private static class_591<?> classicModel, slimModel;

	private SkinRenderer() {
	}

	public static void render(class_4587 graphics, boolean classicVariant,
							  class_2960 skinTexture,
							  @Nullable class_2960 cape,
							  float rotationX,
							  float rotationY,
							  float pivotY,
							  int x0,
							  int y0,
							  int x1,
							  int y1,
							  float scale) {
		if (classicModel == null && classicVariant) {
			classicModel = new class_591<>(0, false);
			classicModel.field_3448 = false;
		}
		if (slimModel == null && !classicVariant) {
			slimModel = new class_591<>(0, true);
			slimModel.field_3448 = false;
		}

		int width = x1 - x0;
		class_308.method_1450();
		graphics.method_22903();
		graphics.method_22904(x0 + width / 2.0F, (float) (y1), 100.0F);
		graphics.method_22905(scale, scale, scale);
		graphics.method_22904(0.0F, -0.0625F, 0.0F);
		graphics.method_22904(0, pivotY, 0);
		graphics.method_22907(class_1160.field_20703.method_23214(rotationX));
		graphics.method_22904(0, -pivotY, 0);
		graphics.method_22907(class_1160.field_20705.method_23214(rotationY));
		graphics.method_22903();
		graphics.method_22905(1.0F, 1.0F, -1.0F);
		graphics.method_22904(0.0F, -1.5F, 0.0F);
		var model = classicVariant ? classicModel : slimModel;
		var tessellator = class_289.method_1348();
		RenderSystem.enableDepthTest();
		RenderSystem.enableBlend();
		RenderSystem.enableTexture();
		class_310.method_1551().method_1531().method_22813(skinTexture);
		var consumer = class_4597.method_22991(tessellator.method_1349()).getBuffer(model.method_23500(skinTexture));
		Consumer<class_630> renderModelPart = m -> m.method_22699(graphics, consumer, 15728880, class_4608.field_21444, 1, 1, 1, 1);
		renderModelPart.accept(model.field_3398);
		renderModelPart.accept(model.field_3391);
		renderModelPart.accept(model.field_3401);
		renderModelPart.accept(model.field_3390);
		renderModelPart.accept(model.field_3392);
		renderModelPart.accept(model.field_3397);
		renderModelPart.accept(model.field_3394);
		renderModelPart.accept(model.field_3482);
		renderModelPart.accept(model.field_3479);
		renderModelPart.accept(model.field_3484);
		graphics.method_22904(0, 0, -0.62f);
		renderModelPart.accept(model.field_3486);
		graphics.method_22904(0, 0, 0.62f);
		renderModelPart.accept(model.field_3483);
		tessellator.method_1350();
		if (cape != null) {
			graphics.method_22903();
			class_310.method_1551().method_1531().method_22813(cape);
			graphics.method_22904(0.0F, 0.0F, 0.125F);
			graphics.method_22907(class_1160.field_20703.method_23214(6.0F));
			graphics.method_22907(class_1160.field_20705.method_23214(180.0F));
			model.method_2823(graphics, class_4597.method_22991(tessellator.method_1349()).getBuffer(class_1921.method_23572(cape)), 15728880, class_4608.field_21444);
			tessellator.method_1350();
			graphics.method_22909();
		}
		graphics.method_22909();

		graphics.method_22909();
		RenderSystem.disableBlend();
		RenderSystem.disableDepthTest();
		class_308.method_24211();
	}
}
