/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.blur;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.ColorOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.IntegerOption;
import io.github.axolotlclient.mixin.ShaderEffectAccessor;
import io.github.axolotlclient.modules.AbstractModule;
import io.github.axolotlclient.util.ClientColors;
import lombok.Getter;
import net.minecraft.class_278;
import net.minecraft.class_279;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_4587;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

/**
 * Totally not stolen from Sol.
 * License: GPL-3.0
 *
 * @author TheKodeToad
 * @author tterag1098
 */

public class MenuBlur extends AbstractModule {

	@Getter
	private static final MenuBlur Instance = new MenuBlur();
	public final BooleanOption enabled = new BooleanOption("enabled", false);
	private final class_2960 shaderLocation = new class_2960("minecraft:shaders/post/menu_blur.json");
	private final IntegerOption strength = new IntegerOption("strength", 8, 0, 100);
	private final IntegerOption fadeTime = new IntegerOption("fadeTime", 1, 0, 10);
	private final ColorOption bgColor = new ColorOption("bgcolor", new Color(0x64000000));
	private final OptionCategory category = OptionCategory.create("menublur");

	private final Color black = new Color(0);

	private long openTime;

	private class_279 shader;

	private int lastWidth;
	private int lastHeight;

	@Override
	public void init() {
		category.add(enabled, strength, fadeTime, bgColor);

		AxolotlClient.config().rendering.add(category);

		AxolotlClient.runtimeResources.put(shaderLocation, new MenuBlurShader());
	}

	public boolean renderScreen(class_4587 matrices) {
		if (enabled.get() && !(class_310.method_1551().field_1755 instanceof class_408) && shader != null) {
			class_332.method_25294(matrices, 0, 0, class_310.method_1551().method_1522().field_1482, class_310.method_1551().method_1522().field_1481,
				ClientColors.blend(black, bgColor.get(), getProgress()).toInt());
			return true;
		}
		return false;
	}

	private float getProgress() {
		return Math.min((System.currentTimeMillis() - openTime) / (fadeTime.get() * 1000F), 1);
	}

	public void updateBlur() {
		if (enabled.get() && class_310.method_1551().field_1755 != null && !(class_310.method_1551().field_1755 instanceof class_408)) {
			if ((shader == null || class_310.method_1551().method_1522().field_1482 != lastWidth
				|| class_310.method_1551().method_1522().field_1481 != lastHeight)
				&& class_310.method_1551().method_1522().field_1482 > 0
				&& class_310.method_1551().method_1522().field_1481 > 0) {
				try {
					shader = new class_279(client.method_1531(), client.method_1478(),
						client.method_1522(), shaderLocation);
					shader.method_1259(client.method_1522().field_1482, client.method_1522().field_1481);
				} catch (IOException e) {
					AxolotlClient.LOGGER.error("Failed to load Menu Blur: ", e);
					return;
				}
			}

			if (shader != null) {
				((ShaderEffectAccessor) shader).getPasses().forEach((shader) -> {
					class_278 radius = shader.method_1295().method_1271("Radius");
					class_278 progress = shader.method_1295().method_1271("Progress");

					if (radius != null) {
						radius.method_1251(strength.get());
					}

					if (progress != null) {
						if (fadeTime.get() > 0) {
							progress.method_1251(getProgress());
						} else {
							progress.method_1251(1);
						}
					}
				});
			}

			lastWidth = client.method_1522().field_1482;
			lastHeight = client.method_1522().field_1481;
			renderBlur();
		}
	}

	public void renderBlur() {
		shader.method_1258(class_310.method_1551().method_1488());
		RenderSystem.enableTexture();
	}

	public void onScreenOpen() {
		openTime = System.currentTimeMillis();
	}

	private static class MenuBlurShader implements class_3298 {

		@Override
		public class_2960 method_14483() {
			return null;
		}

		@Override
		public InputStream method_14482() {
			return IOUtils.toInputStream("{\n" + "    \"targets\": [\n" + "        \"swap\"\n" + "    ],\n"
				+ "    \"passes\": [\n" + "        {\n" + "            \"name\": \"menu_blur\",\n"
				+ "            \"intarget\": \"minecraft:main\",\n" + "            \"outtarget\": \"swap\",\n"
				+ "            \"uniforms\": [\n" + "                {\n"
				+ "                    \"name\": \"BlurDir\",\n" + "                    \"values\": [ 1.0, 0.0 ]\n"
				+ "                },\n" + "                {\n" + "                    \"name\": \"Radius\",\n"
				+ "                    \"values\": [ 0.0 ]\n" + "                }\n" + "            ]\n"
				+ "        },\n" + "        {\n" + "            \"name\": \"menu_blur\",\n"
				+ "            \"intarget\": \"swap\",\n" + "            \"outtarget\": \"minecraft:main\",\n"
				+ "            \"uniforms\": [\n" + "                {\n"
				+ "                    \"name\": \"BlurDir\",\n" + "                    \"values\": [ 0.0, 1.0 ]\n"
				+ "                },\n" + "                {\n" + "                    \"name\": \"Radius\",\n"
				+ "                    \"values\": [ 0.0 ]\n" + "                }\n" + "            ]\n"
				+ "        },\n" + "        {\n" + "            \"name\": \"menu_blur\",\n"
				+ "            \"intarget\": \"minecraft:main\",\n" + "            \"outtarget\": \"swap\",\n"
				+ "            \"uniforms\": [\n" + "                {\n"
				+ "                    \"name\": \"BlurDir\",\n" + "                    \"values\": [ 1.0, 0.0 ]\n"
				+ "                },\n" + "                {\n" + "                    \"name\": \"Radius\",\n"
				+ "                    \"values\": [ 0.0 ]\n" + "                }\n" + "            ]\n"
				+ "        },\n" + "        {\n" + "            \"name\": \"menu_blur\",\n"
				+ "            \"intarget\": \"swap\",\n" + "            \"outtarget\": \"minecraft:main\",\n"
				+ "            \"uniforms\": [\n" + "                {\n"
				+ "                    \"name\": \"BlurDir\",\n" + "                    \"values\": [ 0.0, 1.0 ]\n"
				+ "                },\n" + "                {\n" + "                    \"name\": \"Radius\",\n"
				+ "                    \"values\": [ 0.0 ]\n" + "                }\n" + "            ]\n"
				+ "        }\n" + "    ]\n" + "}", StandardCharsets.UTF_8);
		}

		@Nullable
		@Override
		public <T> T method_14481(class_3270<T> metaReader) {
			return null;
		}

		@Override
		public String method_14480() {
			return null;
		}

		@Override
		public void close() throws IOException {

		}
	}

}
