/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.AxolotlClientConfig;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.util.ConfigStyles;
import io.github.axolotlclient.modules.hud.gui.component.HudEntry;
import io.github.axolotlclient.modules.hud.snapping.SnappingHelper;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import io.github.axolotlclient.modules.hud.util.Rectangle;

/**
 * This implementation of Hud modules is based on KronHUD.
 * <a href="https://github.com/DarkKronicle/KronHUD">Github Link.</a>
 *
 * <p>License: GPL-3.0</p>
 */

public class HudEditScreen extends class_437 {

	private static final BooleanOption snapping = new BooleanOption("snapping", true);
	private static final OptionCategory hudEditScreenCategory = OptionCategory.create("hudEditScreen");

	public static boolean isSnappingEnabled() {
		return snapping.get();
	}

	public static void toggleSnapping() {
		snapping.toggle();
	}

	static {
		hudEditScreenCategory.add(snapping);
		AxolotlClient.config().hidden.add(hudEditScreenCategory);
	}

	private final class_437 parent;
	private HudEntry current;
	private DrawPosition offset = null;
	private boolean mouseDown;
	private SnappingHelper snap;

	public HudEditScreen() {
		this(null);
	}

	public HudEditScreen(class_437 parent) {
		super(class_2585.field_24366);
		updateSnapState();
		mouseDown = false;
		this.parent = parent;
	}

	private void updateSnapState() {
		if (snapping.get() && current != null) {
			List<Rectangle> bounds = HudManager.getInstance().getAllBounds();
			bounds.remove(current.getTrueBounds());
			snap = new SnappingHelper(bounds, current.getTrueBounds());
		} else if (snap != null) {
			snap = null;
		}
	}

	@Override
	public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
		if (class_310.method_1551().field_1687 != null)
			method_25296(matrices, 0, 0, field_22789, field_22790, 0xB0100E0E,
				0x46212020);
		else {
			method_25434(0);
		}

		super.method_25394(matrices, mouseX, mouseY, delta);

		Optional<HudEntry> entry = HudManager.getInstance().getEntryXY(mouseX, mouseY);
		entry.ifPresent(abstractHudEntry -> abstractHudEntry.setHovered(true));
		HudManager.getInstance().renderPlaceholder(matrices, delta);
		if (mouseDown && snap != null) {
			snap.renderSnaps(matrices);
		}
	}

	@Override
	public void method_25426() {
		this.method_25411(new class_4185(field_22789 / 2 - 50, field_22790 / 2 + 12, 100, 20, new class_2588("hud.snapping").method_27693(": ")
			.method_10852(new class_2588(snapping.get() ? "options.on" : "options.off")),
			buttonWidget -> {
				snapping.toggle();
				buttonWidget.method_25355(new class_2588("hud.snapping").method_27693(": ")
					.method_10852(new class_2588(snapping.get() ? "options.on" : "options.off")));
				AxolotlClient.getInstance().saveConfig();
			}));

		this.method_25411(new class_4185(field_22789 / 2 - 75, field_22790 / 2 - 10, 150, 20, new class_2588("hud.clientOptions"),
			buttonWidget -> {
				class_437 screen = ConfigStyles.createScreen(this, AxolotlClient.getInstance().getConfig().config);
				class_310.method_1551().method_1507(screen);
			}));

		if (parent != null)
			method_25411(new class_4185(field_22789 / 2 - 75, field_22790 - 50 + 22, 150, 20, class_5244.field_24339,
				buttonWidget -> class_310.method_1551().method_1507(parent)));
		else
			method_25411(new class_4185(field_22789 / 2 - 75, field_22790 - 50 + 22, 150, 20, new class_2588("close"),
				buttonWidget -> class_310.method_1551().method_1507(null)));
	}

	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		super.method_25402(mouseX, mouseY, button);
		Optional<HudEntry> entry = HudManager.getInstance().getEntryXY((int) Math.round(mouseX),
			(int) Math.round(mouseY));
		if (button == 0) {
			mouseDown = true;
			if (entry.isPresent()) {
				current = entry.get();
				offset = new DrawPosition((int) Math.round(mouseX - current.getTruePos().x()),
					(int) Math.round(mouseY - current.getTruePos().y()));
				updateSnapState();
				return true;
			} else {
				current = null;
			}
		} else if (button == 1) {
			entry.ifPresent(abstractHudEntry -> {
				class_437 screen = ConfigStyles.createScreen(this, abstractHudEntry.getCategory());
				class_310.method_1551().method_1507(screen);
			});
		}
		return false;
	}

	@Override
	public boolean method_25406(double mouseX, double mouseY, int button) {
		if (current != null) {
			AxolotlClientConfig.getInstance().getConfigManager(current.getCategory()).save();
		}
		current = null;
		snap = null;
		mouseDown = false;
		return super.method_25406(mouseX, mouseY, button);
	}

	@Override
	public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
		if (current != null) {
			current.setX((int) mouseX - offset.x() + current.offsetTrueWidth());
			current.setY((int) mouseY - offset.y() + current.offsetTrueHeight());
			if (snap != null) {
				Integer snapX, snapY;
				snap.setCurrent(current.getTrueBounds());
				if ((snapX = snap.getCurrentXSnap()) != null) {
					current.setX(snapX + current.offsetTrueWidth());
				}
				if ((snapY = snap.getCurrentYSnap()) != null) {
					current.setY(snapY + current.offsetTrueHeight());
				}
			}
			if (current.tickable()) {
				current.tick();
			}
			return true;
		}
		return false;
	}
}
