/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.bridge.events.Events;
import io.github.axolotlclient.bridge.events.types.PlayerDirectionChangeEvent;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import lombok.Getter;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import net.minecraft.class_898;

/**
 * This implementation of Hud modules is based on KronHUD.
 * <a href="https://github.com/DarkKronicle/KronHUD">Github Link.</a>
 *
 * <p>License: GPL-3.0</p>
 */

@SuppressWarnings("deprecation")
public class PlayerHud extends PlayerHudCommon {

	public static final class_2960 ID = new class_2960("kronhud", "playerhud");
	@Getter
	private static boolean currentlyRendering;

	public PlayerHud() {
		super();
		Events.PLAYER_DIRECTION_CHANGE.register(this::onPlayerDirectionChange);
	}

	public void onPlayerDirectionChange(PlayerDirectionChangeEvent event) {
		yawOffset += (event.yaw() - event.prevYaw()) / 2;
	}

	@Override
	public void tick() {
		super.tick();
		var client = class_310.method_1551();
		if (client.field_1724 != null && client.field_1724.method_20232()) {
			float rawPitch = client.field_1724.method_5799() ? -90.0F - client.field_1724.method_5695(0) : -90.0F;
			float pitch = class_3532.method_16439(client.field_1724.method_6024(1), 0.0F, rawPitch);
			float height = client.field_1724.method_17682();
			// sin = opposite / hypotenuse
			float offset = (float) (Math.sin(Math.toRadians(pitch)) * height);
			yOffset = Math.abs(offset) + 35;
		} else if (client.field_1724 != null && client.field_1724.method_6128()) {
			// Elytra!

			float j = (float) client.field_1724.method_6003() + 1;
			float k = class_3532.method_15363(j * j / 100.0F, 0.0F, 1.0F);

			float pitch = k * (-90.0F - client.field_1724.method_5695(0)) + 90;
			float height = client.field_1724.method_17682();
			// sin = opposite / hypotenuse
			float offset = (float) (Math.sin(Math.toRadians(pitch)) * height) * 50;
			yOffset = 35 - offset;
			if (pitch < 0) {
				yOffset -= (float) (((1 / (1 + Math.exp(-pitch / 4))) - .5) * 20);
			}
		} else {
			yOffset *= .8f;
		}
	}

	@Override
	protected void renderPlayer(AxoRenderContext ctx, boolean placeholder, double x, double y, float delta) {
		var client = class_310.method_1551();
		if (client.field_1724 == null) {
			return;
		}

		if (!placeholder && autoHide.get()) {
			if (isPerformingAction()) {
				hide = -1;
			} else if (hide == -1) {
				hide = System.currentTimeMillis();
			}

			if (hide != -1 && System.currentTimeMillis() - hide > 500) {
				return;
			}
		}

		float lerpY = (lastYOffset + ((yOffset - lastYOffset) * delta));

		RenderSystem.pushMatrix();
		RenderSystem.translated(x, y - lerpY, 1050);
		RenderSystem.scalef(1, 1, -1);

		class_4587 nextStack = new class_4587();
		nextStack.method_22904(0, 0, 1000);
		float scale = getScale() * 40;
		nextStack.method_22905(scale, scale, scale);

		class_1158 quaternion = class_1160.field_20707.method_23214(180.0F);

		nextStack.method_22907(quaternion);
		// Rotate to whatever is wanted. Also make sure to offset the yaw
		float deltaYaw = client.field_1724.method_5705(delta);
		if (dynamicRotation.get()) {
			deltaYaw -= (lastYawOffset + ((yawOffset - lastYawOffset) * delta));
		}
		nextStack.method_22907(new class_1158(new class_1160(0, 1, 0), deltaYaw - 180 + rotation.get().floatValue(), true));

		// Save these to set them back later
		float pastYaw = client.field_1724.method_5705(0);
		float pastPrevYaw = client.field_1724.field_5982;

		class_308.method_1450();
		class_898 renderer = client.method_1561();
		renderer.method_24196(quaternion);
		renderer.method_3948(false);

		class_4597.class_4598 immediate = class_310.method_1551().method_22940()
			.method_23000();

		currentlyRendering = true;
		renderer.method_3954(client.field_1724, 0, 0, 0, 0, delta, nextStack, immediate, 15728880);
		immediate.method_22993();
		currentlyRendering = false;
		renderer.method_3948(true);
		RenderSystem.popMatrix();

		client.field_1724.method_5636(pastYaw);
		client.field_1724.field_5982 = pastPrevYaw;

		class_308.method_24211();
	}

	private boolean isPerformingAction() {
		// inspired by tr7zw's mod
		class_746 player = class_310.method_1551().field_1724;
		//noinspection DataFlowIssue
		return player.method_5715() || player.method_5624() || player.method_6128() || player.field_7503.field_7479
			|| player.method_5869() || player.method_20232() || player.method_5765()
			|| player.method_6115() || player.field_6252 || player.field_6235 > 0 || player.method_5809();
	}
}
