/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.hud.vanilla;

import java.util.List;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.ColorOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.EnumOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.GraphicsOption;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.gui.component.DynamicallyPositionable;
import io.github.axolotlclient.modules.hud.gui.entry.AbstractHudEntry;
import io.github.axolotlclient.modules.hud.gui.layout.AnchorPoint;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.modules.hud.util.RenderUtil;
import io.github.axolotlclient.util.ClientColors;
import io.github.axolotlclient.util.Util;
import lombok.AllArgsConstructor;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4061;
import net.minecraft.class_4184;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_4739;
import net.minecraft.class_5512;

import static net.minecraft.class_332.method_25293;

/**
 * This implementation of Hud modules is based on KronHUD.
 * <a href="https://github.com/DarkKronicle/KronHUD">Github Link.</a>
 *
 * <p>License: GPL-3.0</p>
 */

public class CrosshairHud extends AbstractHudEntry implements DynamicallyPositionable {

	public static final class_2960 ID = new class_2960("kronhud", "crosshairhud");

	private final EnumOption<Crosshair> type = new EnumOption<>("crosshair_type", Crosshair.class, Crosshair.CROSS);
	private final BooleanOption showInF5 = new BooleanOption("showInF5", false);
	private final ColorOption defaultColor = new ColorOption("defaultcolor", ClientColors.WHITE);
	private final ColorOption entityColor = new ColorOption("entitycolor", ClientColors.SELECTOR_RED);
	private final ColorOption containerColor = new ColorOption("blockcolor", ClientColors.SELECTOR_BLUE);
	private final ColorOption attackIndicatorBackgroundColor = new ColorOption("attackindicatorbg",
		new Color(0xFF141414));
	private final ColorOption attackIndicatorForegroundColor = new ColorOption("attackindicatorfg", ClientColors.WHITE);
	private final BooleanOption applyBlend = new BooleanOption("applyBlend", true);
	private final BooleanOption overrideF3 = new BooleanOption("overrideF3", false);
	private final BooleanOption customAttackIndicator = new BooleanOption("crosshairhud.custom_attack_indicator", false);

	private final GraphicsOption customTextureGraphics = new GraphicsOption("customTextureGraphics",
		new int[][]{
			new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		});
	private final class_310 client = (class_310) super.client;

	public CrosshairHud() {
		super(15, 15);
	}

	@Override
	public boolean movable() {
		return false;
	}

	@Override
	public class_2960 getId() {
		return ID;
	}

	@Override
	public List<Option<?>> getConfigurationOptions() {
		List<Option<?>> options = super.getConfigurationOptions();
		options.add(hide);
		options.add(type);
		options.add(customTextureGraphics);
		options.add(showInF5);
		options.add(overrideF3);
		options.add(applyBlend);
		options.add(defaultColor);
		options.add(entityColor);
		options.add(containerColor);
		options.add(customAttackIndicator);
		options.add(attackIndicatorBackgroundColor);
		options.add(attackIndicatorForegroundColor);
		return options;
	}

	@Override
	public boolean overridesF3() {
		return overrideF3.get();
	}

	@Override
	public double getDefaultX() {
		return 0.5;
	}

	@Override
	public double getDefaultY() {
		return 0.5;
	}

	@SuppressWarnings("deprecation")
	@Override
	public void render(AxoRenderContext context, float delta) {
		class_4587 matrices = (class_4587) context;

		if (!client.field_1690.method_31044().method_31034() && !showInF5.get()) {
			return;
		}

		RenderSystem.color4f(1, 1, 1, 1);

		matrices.method_22903();
		scale(matrices);

		int x = getPos().x;
		int y = getPos().y + 1;
		Color color = getColor();
		class_4061 indicator = this.client.field_1690.field_1895;

		RenderSystem.enableBlend();

		// Need to not enable blend while the debug HUD is open because it does weird stuff. Why? no idea.
		if (color == defaultColor.get() && !type.get().equals(Crosshair.DIRECTION) && applyBlend.get()
			&& !client.field_1690.field_1866) {
			RenderSystem.blendFuncSeparate(class_4493.class_4535.field_22538,
				class_4493.class_4534.field_22524, class_4493.class_4535.field_22534,
				class_4493.class_4534.field_22527);
		} else {
			RenderSystem.disableBlend();
		}

		if (type.get().equals(Crosshair.DOT)) {
			RenderUtil.fillBlend(matrices, x + (getWidth() / 2) - 2, y + (getHeight() / 2) - 2, 3, 3, color);
		} else if (type.get().equals(Crosshair.CROSS)) {
			RenderUtil.fillBlend(matrices, x + (getWidth() / 2) - 6, y + (getHeight() / 2) - 1, 6, 1, color);
			RenderUtil.fillBlend(matrices, x + (getWidth() / 2), y + (getHeight() / 2) - 1, 5, 1, color);
			RenderUtil.fillBlend(matrices, x + (getWidth() / 2) - 1, y + (getHeight() / 2) - 6, 1, 5, color);
			RenderUtil.fillBlend(matrices, x + (getWidth() / 2) - 1, y + (getHeight() / 2), 1, 5, color);
		} else if (type.get().equals(Crosshair.DIRECTION)) {
			// TODO... uh
			RenderSystem.pushMatrix();
			RenderSystem.translatef(client.method_22683().method_4486() / 2F, client.method_22683().method_4502() / 2F, 0);
			class_4184 camera = this.client.field_1773.method_19418();
			RenderSystem.rotatef(camera.method_19329(), -1.0F, 0.0F, 0.0F);
			RenderSystem.rotatef(camera.method_19330(), 0.0F, 1.0F, 0.0F);
			RenderSystem.scalef(-getScale(), -getScale(), -getScale());
			RenderSystem.renderCrosshair(10);
			RenderSystem.popMatrix();
		} else if (type.get().equals(Crosshair.TEXTURE) || type.get().equals(Crosshair.CUSTOM)) {
			RenderSystem.color4f(1.0F, 1.0F, 1.0F, 1.0F);
			if (type.get().equals(Crosshair.TEXTURE)) {
				class_310.method_1551().method_1531().method_22813(class_332.field_22737);
				// Draw crosshair
				RenderSystem.color4f((float) color.getRed() / 255, (float) color.getGreen() / 255,
					(float) color.getBlue() / 255, (float) color.getAlpha() / 255);
				method_25290(matrices,
					(int) (((client.method_22683().method_4486() / getScale()) - 15) / 2),
					(int) (((client.method_22683().method_4502() / getScale()) - 15) / 2), 0, 0, 15, 15, 256, 256);
			} else {
				Util.bindTexture(customTextureGraphics);
				// Draw crosshair
				RenderSystem.color4f((float) color.getRed() / 255, (float) color.getGreen() / 255,
					(float) color.getBlue() / 255, (float) color.getAlpha() / 255);

				method_25290(matrices,
					(int) (((client.method_22683().method_4486() / getScale()) - 15) / 2),
					(int) (((client.method_22683().method_4502() / getScale()) - 15) / 2), 0, 0, 15, 15, 15, 15);

				class_310.method_1551().method_1531().method_22813(class_332.field_22737);
			}

			RenderSystem.color4f(1, 1, 1, 1);

			if (!customAttackIndicator.get()) {
				// Draw attack indicator
				x = (int) ((client.method_22683().method_4486() / getScale()) / 2 - 8);
				y = (int) ((client.method_22683().method_4502() / getScale()) / 2 - 7 + 16);
				//noinspection DataFlowIssue
				class_1799 itemStack = this.client.field_1724.method_5998(class_1268.field_5810);
				boolean bl = this.client.field_1690.field_26808 == class_5512.field_26811;
				if (bl && itemStack.method_7909() == class_1802.field_8255 && this.client.field_1724.method_31233(itemStack)) {
					new DrawUtil().method_25302(matrices, x, y, 52, 112, 16, 16);
				} else if (bl && this.client.field_1724.method_6039()) {
					new DrawUtil().method_25302(matrices, x, y, 36, 112, 16, 16);
				} else if (this.client.field_1690.field_1895 == class_4061.field_18152) {
					float f = this.client.field_1724.method_7261(0.0F);
					boolean bl2 = false;
					if (this.client.field_1692 != null && this.client.field_1692 instanceof class_1309 && f >= 2.0F) {
						//noinspection DataFlowIssue
						bl2 = ((class_3966) this.client.field_1765).method_31252() <= this.client.field_1724.method_31239(0.0F);
						bl2 &= this.client.field_1692.method_5805();
					}

					if (bl2) {
						new DrawUtil().method_25302(matrices, x, y, 68, 94, 16, 16);
					} else if (f > 1.3F && f < 2.0F) {
						float h = (f - 1.0F);
						int l = (int) (h * 17.0F);
						new DrawUtil().method_25302(matrices, x, y, 36, 94, 16, 4);
						new DrawUtil().method_25302(matrices, x, y, 52, 94, l, 4);
					}
				}
			}
		}
		if (((type.get().equals(Crosshair.TEXTURE) || type.get().equals(Crosshair.CUSTOM)) ? customAttackIndicator.get() : true) && indicator == class_4061.field_18152) {
			//noinspection DataFlowIssue
			float progress = this.client.field_1724.method_7261(0.0F) / 2;
			if (progress != 1.0F) {
				RenderUtil.drawRectangle(matrices, getRawX() + (getWidth() / 2) - 6, getRawY() + (getHeight() / 2) + 9,
					11, 1, attackIndicatorBackgroundColor.get());
				RenderUtil.drawRectangle(matrices, getRawX() + (getWidth() / 2) - 6, getRawY() + (getHeight() / 2) + 9,
					(int) (progress * 11), 1, attackIndicatorForegroundColor.get());
			}
		}
		RenderSystem.disableBlend();
		matrices.method_22909();
	}

	public Color getColor() {
		class_239 hit = client.field_1765;
		if (hit == null || hit.method_17783() == null) {
			return defaultColor.get();
		} else //noinspection DataFlowIssue
			if (hit.method_17783() == class_239.class_240.field_1331 && ((class_3966) this.client.field_1765).method_31252() <= this.client.field_1724.method_31239(0.0F)) {
			return entityColor.get();
		} else if (hit.method_17783() == class_239.class_240.field_1332) {
			class_2338 blockPos = ((class_3965) hit).method_17777();
			class_1937 world = this.client.field_1687;
			//noinspection DataFlowIssue
			if (world.method_8320(blockPos).method_26196(world, blockPos) != null
				|| world.method_8320(blockPos).method_26204() instanceof class_4739<?>) {
				return containerColor.get();
			}
		}
		return defaultColor.get();
	}

	@Override
	public void renderPlaceholder(AxoRenderContext matrices, float delta) {
		// Shouldn't need this...
	}

	@Override
	public AnchorPoint getAnchor() {
		return AnchorPoint.MIDDLE_MIDDLE;
	}

	@AllArgsConstructor
	public enum Crosshair {
		CROSS, DOT, DIRECTION, TEXTURE, CUSTOM
	}
}
