/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.hud.vanilla;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4061;
import net.minecraft.class_4587;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import io.github.axolotlclient.modules.hud.util.ItemUtil;

import static io.github.axolotlclient.modules.hud.util.DrawUtil.drawCenteredString;
import static net.minecraft.class_332.method_25293;

public class HotbarHUD extends TextHudEntry {

	public static final class_2960 ID = new class_2960("axolotlclient", "hotbarhud");
	private static final class_2960 WIDGETS_TEXTURE = new class_2960("textures/gui/widgets.png");

	private final class_310 client = (class_310) super.client;

	public HotbarHUD() {
		super(182, 22, false);
		supportsScaling = false;
	}

	@Override
	public void renderComponent(AxoRenderContext context, float delta) {
		final var matrices = (class_4587) context;
		matrices.br$pushMatrix();
		class_1657 playerEntity = class_310.method_1551().field_1719 instanceof class_1657
			? (class_1657) class_310.method_1551().field_1719
			: null;
		if (playerEntity != null) {
			DrawPosition pos = getPos();

			RenderSystem.color4f(1.0F, 1.0F, 1.0F, 1.0F);
			class_310.method_1551().method_1531().method_22813(WIDGETS_TEXTURE);
			RenderSystem.enableBlend();
			class_1799 itemStack = playerEntity.method_6079();
			class_1306 arm = playerEntity.method_6068().method_5928();

			matrices.br$pushMatrix();
			method_25290(matrices, pos.x, pos.y, 0, 0, 182, 22, 256, 256);
			method_25290(matrices, pos.x - 1 + playerEntity.field_7514.field_7545 * 20, pos.y - 1, 0, 22, 24,
				22, 256, 256);
			if (!itemStack.method_7960()) {
				if (arm == class_1306.field_6182) {
					method_25290(matrices, pos.x - 29, pos.y - 1, 24, 22, 29, 24, 256, 256);
				} else {
					method_25290(matrices, pos.x + width, pos.y - 1, 53, 22, 29, 24, 256, 256);
				}
			}

			matrices.br$popMatrix();

			for (int n = 0; n < 9; ++n) {
				int k = pos.x + n * 20 + 3;
				int l = pos.y + 3;
				ItemUtil.renderGuiItemModel(getScale(), playerEntity.field_7514.field_7547.get(n), k, l);
				ItemUtil.renderGuiItemOverlay(matrices, client.field_1772, playerEntity.field_7514.field_7547.get(n), k,
					l, null, -1, true);
			}

			if (!itemStack.method_7960()) {
				if (arm == class_1306.field_6182) {
					ItemUtil.renderGuiItemModel(getScale(), itemStack, pos.x - 26, pos.y + 3);
					ItemUtil.renderGuiItemOverlay(matrices, client.field_1772, itemStack, pos.x - 26, pos.y + 3, null,
						-1, true);
				} else {
					ItemUtil.renderGuiItemModel(getScale(), itemStack, pos.x + width + 10, pos.y + 3);
					ItemUtil.renderGuiItemOverlay(matrices, client.field_1772, itemStack, pos.x + width + 10,
						pos.y + 3, null, -1, true);
				}
			}

			if (this.client.field_1690.field_1895 == class_4061.field_18153) {
				float f = this.client.field_1724.method_7261(0.0F);
				if (f < 1.0F) {
					int o = pos.y + 2;
					int p = pos.x + width + 6;
					if (arm == class_1306.field_6183) {
						p = pos.x - 22;
					}

					class_310.method_1551().method_1531().method_22813(class_332.field_22737);
					int q = (int) (f * 19.0F);
					RenderSystem.color4f(1.0F, 1.0F, 1.0F, 1.0F);
					method_25290(matrices, p, o, 0, 94, 18, 18, 256, 256);
					method_25290(matrices, p, o + 18 - q, 18, 112 - q, 18, q, 256, 256);
				}
			}

			RenderSystem.disableBlend();
		}
		matrices.br$popMatrix();
	}

	@Override
	public void renderPlaceholderComponent(AxoRenderContext matrices, float delta) {
		DrawPosition pos = getPos();

		drawCenteredString((class_4587) matrices, class_310.method_1551().field_1772, getName(), pos.x + width / 2,
			pos.y + height / 2 - 4, -1, true);
	}

	@Override
	public boolean movable() {
		return true;
	}

	@Override
	public class_2960 getId() {
		return ID;
	}

	@Override
	public boolean overridesF3() {
		return true;
	}

	@Override
	public List<Option<?>> getConfigurationOptions() {
		List<Option<?>> list = new ArrayList<>();
		list.add(enabled);
		list.add(hide);
		return list;
	}
}
