/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.keystrokes;

import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;

import com.google.common.collect.ImmutableList;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.IntegerOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.IntegerWidget;
import io.github.axolotlclient.modules.hud.gui.hud.KeystrokeHud;
import io.github.axolotlclient.modules.hud.gui.layout.Justification;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import lombok.Getter;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class ConfigureKeyBindScreen extends io.github.axolotlclient.AxolotlClientConfig.impl.ui.Screen {

	private final class_437 parent;
	private final KeystrokeHud hud;
	public final KeystrokeHud.Keystroke stroke;
	private final IntegerOption width;
	private final IntegerOption height;
	private final boolean isAddScreen;

	public ConfigureKeyBindScreen(class_437 parent, KeystrokeHud hud, KeystrokeHud.Keystroke stroke, boolean isAddScreen) {
		super("keystrokes.stroke.configure_stroke");
		this.parent = parent;
		this.hud = hud;
		this.stroke = stroke;

		width = new IntegerOption("", stroke.getBounds().width(), v -> stroke.getBounds().width(v), 7, 100);
		height = new IntegerOption("", stroke.getBounds().height(), v -> stroke.getBounds().height(v), 7, 100);
		this.isAddScreen = isAddScreen;
	}

	@Override
	public void method_25426() {
		super.method_25426();

		int leftColX = super.field_22789 / 2 - 4 - 150;
		int leftColY = 36 + 5;
		int rightColX = super.field_22789 / 2 + 4;
		int rightColY = 36;

		addDrawableChild(new class_339(super.field_22789 / 2 - 100, rightColY, 200, 40, class_2585.field_24366) {
			@Override
			public void method_25359(class_4587 guiGraphics, int mouseX, int mouseY, float partialTick) {
				var rect = stroke.getRenderPosition();
				guiGraphics.method_22903();
				guiGraphics.method_22904(field_22760, field_22761, 0);
				float scale = Math.min((float) method_25364() / rect.height(), (float) method_25368() / rect.width());
				guiGraphics.method_22904(method_25368() / 2f - (rect.width() * scale) / 2f, 0, 0);
				guiGraphics.method_22905(scale, scale, 1);
				guiGraphics.method_22904(-rect.x(), -rect.y(), 0);
				DrawUtil.fillRect(guiGraphics, rect, Colors.WHITE.withAlpha(128));
				stroke.render(guiGraphics);
				guiGraphics.method_22909();
			}
		}).field_22763 = false;
		leftColY += 48;
		rightColY += 48;

		class_339 currentKey = addDrawableChild(textWidget(0, rightColY, super.field_22789, 9, class_2585.field_24366, field_22793));
		if (stroke.getKey() != null) {
			currentKey.method_25355(new class_2588("keystrokes.stroke.key", stroke.getKey().getBoundKeyLocalizedText(), new class_2588(stroke.getKey().getTranslationKey())));
		} else {
			currentKey.method_25355(class_2585.field_24366);
		}
		leftColY += 9 + 8;
		rightColY += 9 + 8;

		if (stroke.isLabelEditable()) {
			addDrawableChild(textWidget(leftColX, leftColY, 150, 20, new class_2588("keystrokes.stroke.label"), field_22793));
			leftColY += 28;
			boolean supportsSynchronization = stroke instanceof KeystrokeHud.LabelKeystroke;

			var label = addDrawableChild(new class_342(field_22793, rightColX, rightColY, supportsSynchronization ? 30 : 150, 20, class_2585.field_24366));

			label.method_1852(stroke.getLabel());
			label.method_1863(stroke::setLabel);
			if (supportsSynchronization) {
				var s = (KeystrokeHud.LabelKeystroke) stroke;
				class_4185 synchronizeButton = addDrawableChild(new class_4185(rightColX + 30 + 4, rightColY, 58, 20,
					new class_2588("keystrokes.stroke.label.synchronize_with_key", s.isSynchronizeLabel() ? class_5244.field_24332 : class_5244.field_24333), b -> {
					s.setSynchronizeLabel(!s.isSynchronizeLabel());
					b.method_25355(new class_2588("keystrokes.stroke.label.synchronize_with_key", s.isSynchronizeLabel() ? class_5244.field_24332 : class_5244.field_24333));
					label.method_1888(!s.isSynchronizeLabel());
					if (s.isSynchronizeLabel()) {
						label.method_1852(stroke.getLabel());
					}
				}));
				synchronizeButton.field_22763 = s.getKey() != null;
				label.method_1888(!s.isSynchronizeLabel());
				addDrawableChild(CyclingButtonWidget.<Justification>builder(j -> new class_2588(j.toString())).values(Justification.values())
					.initially(s.getJustification()).build(rightColX + 30 + 4 + 58 + 4, rightColY, 58, 20,
						new class_2588("justification"), (btn, val) -> s.setJustification(val)));
			}
			rightColY += 28;
		}
		addDrawableChild(textWidget(leftColX, leftColY, 150, 20, new class_2588("keystrokes.stroke.width"), field_22793));
		leftColY += 28;
		addDrawableChild(new IntegerWidget(rightColX, rightColY, 150, 20, width));
		rightColY += 28;
		addDrawableChild(textWidget(leftColX, leftColY, 150, 20, new class_2588("keystrokes.stroke.height"), field_22793));
		leftColY += 28;
		addDrawableChild(new IntegerWidget(rightColX, rightColY, 150, 20, height));

		rightColY += 28;

		addDrawableChild(new class_4185(super.field_22789 / 2 - 150 - 4, rightColY, 150, 20,
			new class_2588("keystrokes.stroke.configure_key"), b -> {
			field_22787.method_1507(new KeyBindSelectionScreen(this, stroke));
		}));
		addDrawableChild(new class_4185(super.field_22789 / 2 + 4, rightColY, 150, 20,
			new class_2588("keystrokes.stroke.configure_position"), b -> {
			field_22787.method_1507(new KeystrokePositioningScreen(this, hud, stroke));
		}));


		if (isAddScreen) {
			class_4185 addButton = addDrawableChild(new class_4185(super.field_22789 / 2 - 150 - 4, super.field_22790 - 33 / 2 - 10, 150, 20,
				new class_2588("keystrokes.stroke.add"), b -> {
				hud.keystrokes.add(stroke);
				method_25419();
			}));
			addButton.field_22763 = stroke.getKey() != null;
		}
		addDrawableChild(new class_4185(isAddScreen ? super.field_22789 / 2 + 4 : super.field_22789 / 2 - 75, super.field_22790 - 33 / 2 - 10, 150, 20,
			isAddScreen ? class_5244.field_24335 : class_5244.field_24339, b -> method_25419()));
	}

	@Override
	public void method_25394(class_4587 graphics, int mouseX, int mouseY, float delta) {
		method_25420(graphics);
		super.method_25394(graphics, mouseX, mouseY, delta);
		method_27534(graphics, field_22793, method_25440(), super.field_22789 / 2, 33 / 2 - field_22793.field_2000 / 2, -1);
	}

	@Override
	public void method_25419() {
		field_22787.method_1507(parent);
		hud.saveKeystrokes();
	}

	private static class_339 textWidget(int x, int y, int width, int height, class_2561 text, class_327 renderer) {
		var widget = new class_339(x, y, width, height, text) {
			@Override
			public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
				method_27534(matrices, renderer, method_25369(), field_22760 + field_22758 / 2, field_22761, -1);
			}
		};
		widget.field_22763 = false;
		return widget;
	}
}

class CyclingButtonWidget<T> extends class_4185 {
	private final class_2561 optionText;
	private int index;
	@Getter
	private T value;
	private final CyclingButtonWidget.Values<T> values;
	private final Function<T, class_2561> valueToText;
	private final Function<CyclingButtonWidget<T>, class_5250> narrationMessageFactory;
	private final CyclingButtonWidget.UpdateCallback<T> callback;

	CyclingButtonWidget(int x, int y, int width, int height, class_2561 message, class_2561 optionText, int index, T value,
						CyclingButtonWidget.Values<T> values, Function<T, class_2561> valueToText,
						Function<CyclingButtonWidget<T>, class_5250> narrationMessageFactory,
						CyclingButtonWidget.UpdateCallback<T> callback) {
		super(x, y, width, height, message, btn -> {
		});
		this.optionText = optionText;
		this.index = index;
		this.value = value;
		this.values = values;
		this.valueToText = valueToText;
		this.narrationMessageFactory = narrationMessageFactory;
		this.callback = callback;
	}

	@Override
	public void method_25306() {
		if (class_437.method_25442()) {
			this.cycle(-1);
		} else {
			this.cycle(1);
		}
	}

	private void cycle(int amount) {
		List<T> list = this.values.getCurrent();
		this.index = class_3532.method_15387(this.index + amount, list.size());
		T object = list.get(this.index);
		this.internalSetValue(object);
		this.callback.onValueChange(this, object);
	}

	@Override
	public boolean method_25401(double mouseX, double mouseY, double amount) {
		if (amount > 0.0) {
			this.cycle(-1);
		} else if (amount < 0.0) {
			this.cycle(1);
		}

		return true;
	}

	public void setValue(T value) {
		List<T> list = this.values.getCurrent();
		int i = list.indexOf(value);
		if (i != -1) {
			this.index = i;
		}

		this.internalSetValue(value);
	}

	private void internalSetValue(T value) {
		class_2561 text = this.composeText(value);
		this.method_25355(text);
		this.value = value;
	}

	private class_2561 composeText(T value) {
		return this.composeGenericOptionText(value);
	}

	private class_5250 composeGenericOptionText(T value) {
		return this.optionText.method_27662().method_27693(": ").method_10852(this.valueToText.apply(value));
	}

	@Override
	protected class_5250 method_25360() {
		return this.narrationMessageFactory.apply(this);
	}

	public class_5250 getGenericNarrationMessage() {
		return new class_2588("gui.narrate.button", this.method_25369());
	}

	static <T> CyclingButtonWidget.Builder<T> builder(Function<T, class_2561> valueToText) {
		return new CyclingButtonWidget.Builder<>(valueToText);
	}

	static class Builder<T> {
		private int initialIndex;
		@Nullable
		private T value;
		private final Function<T, class_2561> valueToText;
		private CyclingButtonWidget.Values<T> values = CyclingButtonWidget.Values.of(ImmutableList.<T>of());

		public Builder(Function<T, class_2561> valueToText) {
			this.valueToText = valueToText;
		}

		public CyclingButtonWidget.Builder<T> values(Collection<T> values) {
			return this.values(CyclingButtonWidget.Values.of(values));
		}

		@SafeVarargs
		public final CyclingButtonWidget.Builder<T> values(T... values) {
			return this.values(ImmutableList.copyOf(values));
		}

		public CyclingButtonWidget.Builder<T> values(CyclingButtonWidget.Values<T> values) {
			this.values = values;
			return this;
		}

		public CyclingButtonWidget.Builder<T> initially(T value) {
			this.value = value;
			int i = this.values.getDefaults().indexOf(value);
			if (i != -1) {
				this.initialIndex = i;
			}

			return this;
		}

		public CyclingButtonWidget<T> build(int x, int y, int width, int height, class_2561 optionText, CyclingButtonWidget.UpdateCallback<T> callback) {
			List<T> list = this.values.getDefaults();
			if (list.isEmpty()) {
				throw new IllegalStateException("No values for cycle button");
			} else {
				T object = this.value != null ? this.value : list.get(this.initialIndex);
				class_2561 text = this.valueToText.apply(object);
				class_2561 text2 = optionText.method_27662().method_27693(": ").method_10852(text);
				return new CyclingButtonWidget<>(
					x,
					y,
					width,
					height,
					text2,
					optionText,
					this.initialIndex,
					object,
					this.values,
					this.valueToText,
					CyclingButtonWidget::getGenericNarrationMessage,
					callback
				);
			}
		}
	}

	interface UpdateCallback<T> {
		void onValueChange(CyclingButtonWidget<T> cyclingButtonWidget, T object);
	}

	interface Values<T> {
		List<T> getCurrent();

		List<T> getDefaults();

		static <T> CyclingButtonWidget.Values<T> of(Collection<T> values) {
			final List<T> list = ImmutableList.copyOf(values);
			return new CyclingButtonWidget.Values<>() {
				@Override
				public List<T> getCurrent() {
					return list;
				}

				@Override
				public List<T> getDefaults() {
					return list;
				}
			};
		}

		static <T> CyclingButtonWidget.Values<T> of(BooleanSupplier alternativeToggle, List<T> defaults, List<T> alternatives) {
			final List<T> list = ImmutableList.copyOf(defaults);
			final List<T> list2 = ImmutableList.copyOf(alternatives);
			return new CyclingButtonWidget.Values<>() {
				@Override
				public List<T> getCurrent() {
					return alternativeToggle.getAsBoolean() ? list2 : list;
				}

				@Override
				public List<T> getDefaults() {
					return list;
				}
			};
		}
	}
}
