/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.keystrokes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

import com.google.common.collect.ImmutableList;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.ElementListWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import org.apache.commons.lang3.ArrayUtils;

@Environment(EnvType.CLIENT)
public class KeyBindSelectionList extends ElementListWidget<KeyBindSelectionList.Entry> {
	private static final int ITEM_HEIGHT = 20;
	final KeyBindSelectionScreen keyBindsScreen;
	private final Consumer<class_304> selectionConsumer;

	public KeyBindSelectionList(KeyBindSelectionScreen keyBindsScreen, class_310 minecraft, Consumer<class_304> selectionConsumer) {
		super(minecraft, keyBindsScreen.field_22789, keyBindsScreen.field_22790, 33, keyBindsScreen.field_22790 - 33, ITEM_HEIGHT);
		this.keyBindsScreen = keyBindsScreen;
		this.selectionConsumer = selectionConsumer;
		class_304[] keyMappings = ArrayUtils.clone(minecraft.field_1690.field_1839);
		Arrays.sort(keyMappings);
		String string = null;

		for (class_304 keyMapping : keyMappings) {
			String string2 = keyMapping.method_1423();
			if (!string2.equals(string)) {
				string = string2;
				this.addEntry(new CategoryEntry(new class_2588(string2)));
			}

			class_2561 component = new class_2588(keyMapping.method_1431());

			this.addEntry(new KeyEntry(keyMapping, component));
		}
	}

	@Override
	public int getRowWidth() {
		return 340;
	}

	@Override
	protected int getScrollbarPositionX() {
		return getRowLeft() + getRowWidth() + 10;
	}

	@Environment(EnvType.CLIENT)
	public class CategoryEntry extends io.github.axolotlclient.modules.hud.gui.keystrokes.KeyBindSelectionList.Entry {
		final class_2561 name;
		private final int width;

		public CategoryEntry(final class_2561 name) {
			this.name = name;
			this.width = KeyBindSelectionList.this.client.field_1772.method_27525(this.name);
		}

		@Override
		public void render(class_4587 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
			KeyBindSelectionList.this.client.field_1772.method_30881(guiGraphics, this.name, KeyBindSelectionList.this.width / 2f - this.width / 2f, top + height - 9 - 1, -1);
		}

		@Override
		public List<? extends class_364> method_25396() {
			return Collections.emptyList();
		}
	}

	@Environment(EnvType.CLIENT)
	public abstract static class Entry extends ElementListWidget.Entry<io.github.axolotlclient.modules.hud.gui.keystrokes.KeyBindSelectionList.Entry> {

	}

	@Environment(EnvType.CLIENT)
	public class KeyEntry extends io.github.axolotlclient.modules.hud.gui.keystrokes.KeyBindSelectionList.Entry {
		private final class_2561 name, boundKey;
		private final class_4185 changeButton;

		KeyEntry(final class_304 key, final class_2561 name) {
			this.name = name;
			this.boundKey = key.method_16007();
			this.changeButton = new class_4185(0, 0, 75, 20, new class_2588("keystrokes.key.select"), button -> {
				selectionConsumer.accept(key);
				keyBindsScreen.method_25419();
			});
			changeButton.field_22763 = !(keyBindsScreen.stroke.getKey() != null && key == keyBindsScreen.stroke.getKey());
		}

		@Override
		public void render(class_4587 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
			int i = KeyBindSelectionList.this.getScrollbarPositionX() - 10;
			int j = top - 2;
			int k = i - 5 - this.changeButton.method_25368();
			this.changeButton.field_22760 = k;
			this.changeButton.field_22761 = j;
			this.changeButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
			client.field_1772.method_30881(guiGraphics, this.name, left, top + height / 2f - 9 / 2f, -1);
			client.field_1772.method_30881(guiGraphics, boundKey, left + width / 2f - client.field_1772.method_27525(boundKey) / 2f, top + height / 2f - 9 / 2f, Colors.GRAY.toInt());
		}

		@Override
		public List<? extends class_364> method_25396() {
			return ImmutableList.of(this.changeButton);
		}
	}
}
