/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.keystrokes;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_2588;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.modules.hud.HudEditScreen;
import io.github.axolotlclient.modules.hud.HudManager;
import io.github.axolotlclient.modules.hud.gui.hud.KeystrokeHud;
import io.github.axolotlclient.modules.hud.snapping.SnappingHelper;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.modules.hud.util.Rectangle;
import io.github.axolotlclient.util.ClientColors;

public class KeystrokePositioningScreen extends io.github.axolotlclient.AxolotlClientConfig.impl.ui.Screen {
	private final class_437 parent;
	private final KeystrokeHud hud;
	private KeystrokeHud.Keystroke focused;
	private final KeystrokeHud.Keystroke editing;

	public KeystrokePositioningScreen(class_437 parent, KeystrokeHud hud, KeystrokeHud.Keystroke focused) {
		super("keystrokes.stroke.move");
		this.parent = parent;
		this.hud = hud;
		if (hud.keystrokes == null) {
			hud.setKeystrokes();
		}
		this.editing = focused;
		mouseDown = false;
	}

	public KeystrokePositioningScreen(class_437 parent, KeystrokeHud hud) {
		this(parent, hud, null);
	}

	private DrawPosition offset = null;
	private boolean mouseDown;
	private SnappingHelper snap;

	@Override
	public void method_25426() {
		super.method_25426();
		addDrawableChild(new class_4185(field_22789 / 2 - 75, field_22790 - 50 + 22, 150, 20, class_5244.field_24339, b -> method_25419()));
		this.addDrawableChild(new class_4185(field_22789 / 2 - 50, field_22790 - 50, 100, 20, new class_2588("hud.snapping").method_27693(": ")
			.method_10852(new class_2588(HudEditScreen.isSnappingEnabled() ? "options.on" : "options.off")),
			buttonWidget -> {
				HudEditScreen.toggleSnapping();
				buttonWidget.method_25355(new class_2588("hud.snapping").method_27693(": ")
					.method_10852(new class_2588(HudEditScreen.isSnappingEnabled() ? "options.on" : "options.off")));
				AxolotlClient.getInstance().saveConfig();
			}));
	}

	@Override
	public void method_25394(class_4587 guiGraphics, int mouseX, int mouseY, float partialTick) {
		guiGraphics.method_22903();
		guiGraphics.method_22904(0, 0, -300);
		super.method_25420(guiGraphics);
		HudManager.getInstance().renderPlaceholder(guiGraphics, partialTick);
		guiGraphics.method_22909();
		method_25296(guiGraphics, 0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
		super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
		if (editing != null) {
			drawStroke(guiGraphics, mouseX, mouseY, editing);
		} else {
			hud.keystrokes.forEach(s -> drawStroke(guiGraphics, mouseX, mouseY, s));
		}
		if (mouseDown && snap != null) {
			snap.renderSnaps(guiGraphics);
		}
	}

	private void drawStroke(class_4587 guiGraphics, int mouseX, int mouseY, KeystrokeHud.Keystroke s) {
		var rect = getScaledRenderPos(s);
		if (rect.isMouseOver(mouseX, mouseY)) {
			DrawUtil.fillRect(guiGraphics, rect, ClientColors.SELECTOR_BLUE.withAlpha(100));
		} else {
			DrawUtil.fillRect(guiGraphics, rect, ClientColors.WHITE.withAlpha(50));
		}
		guiGraphics.method_22903();
		guiGraphics.method_22905(hud.getScale(), hud.getScale(), 1);
		s.render(guiGraphics);
		guiGraphics.method_22909();
		DrawUtil.outlineRect(guiGraphics, rect, Colors.BLACK);
	}

	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		var value = super.method_25402(mouseX, mouseY, button);
		if (button == 0) {
			Optional<KeystrokeHud.Keystroke> entry = Optional.empty();
			Optional<Rectangle> pos = Optional.empty();
			if (editing == null) {
				for (KeystrokeHud.Keystroke k : hud.keystrokes) {
					pos = Optional.of(getScaledRenderPos(k));
					if (pos.get().isMouseOver(mouseX, mouseY)) {
						entry = Optional.of(k);
						break;
					}
				}
			} else {
				pos = Optional.of(getScaledRenderPos(editing));
				if (pos.get().isMouseOver(mouseX, mouseY)) {
					entry = Optional.of(editing);
				}
			}
			if (entry.isPresent()) {
				focused = entry.get();
				mouseDown = true;
				var rect = pos.get();
				offset = new DrawPosition((int) Math.round(mouseX - rect.x()),
					(int) Math.round(mouseY - rect.y()));
				updateSnapState();
				return true;
			} else {
				focused = null;
			}
		}
		return value;
	}

	@Override
	public void method_25419() {
		field_22787.method_1507(parent);
		hud.saveKeystrokes();
	}

	@Override
	public boolean method_25406(double mouseX, double mouseY, int button) {
		if (focused != null) {
			hud.saveKeystrokes();
		}
		snap = null;
		mouseDown = false;
		focused = null;
		return super.method_25406(mouseX, mouseY, button);
	}

	@Override
	public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
		if (focused != null && mouseDown) {
			focused.setX((int) Math.round((mouseX - offset.x()) / hud.getScale()));
			focused.setY((int) Math.round((mouseY - offset.y()) / hud.getScale()));
			if (snap != null) {
				Integer snapX, snapY;
				var rect = getScaledRenderPos(focused);
				snap.setCurrent(rect);
				if ((snapX = snap.getCurrentXSnap()) != null) {
					focused.setX((int) (snapX / hud.getScale()));
				}
				if ((snapY = snap.getCurrentYSnap()) != null) {
					focused.setY(Math.round(snapY / hud.getScale()));
				}
			}
			return true;
		}
		return false;
	}

	private Rectangle getScaledRenderPos(KeystrokeHud.Keystroke stroke) {
		return stroke.getRenderPosition().scale(hud.getScale());
	}

	private List<Rectangle> getAllBounds() {
		return Stream.concat(HudManager.getInstance().getAllBounds().stream(), hud.keystrokes.stream().map(this::getScaledRenderPos)).toList();
	}

	private void updateSnapState() {
		if (HudEditScreen.isSnappingEnabled() && focused != null) {
			snap = new SnappingHelper(getAllBounds(), getScaledRenderPos(focused));
		} else if (snap != null) {
			snap = null;
		}
	}
}
