/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.util;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.util.ClientColors;
import lombok.experimental.UtilityClass;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_746;
import net.minecraft.class_809;

/**
 * This implementation of Hud modules is based on KronHUD.
 * <a href="https://github.com/DarkKronicle/KronHUD">Github Link.</a>
 *
 * <p>License: GPL-3.0</p>
 */

@SuppressWarnings("deprecation")
@UtilityClass
public class ItemUtil {
	public void renderGuiItemModel(float scale, class_1799 stack, float x, float y) {
		class_308.method_1450();
		class_310 client = class_310.method_1551();
		class_1087 model = client.method_1480().method_4019(stack, null, null);
		RenderSystem.pushMatrix();
		RenderSystem.scalef(scale, scale, 1);
		client.method_1531().method_22813(class_1059.field_5275);
		//noinspection DataFlowIssue
		client.method_1531().method_4619(class_1059.field_5275).method_4527(false, false);
		RenderSystem.enableRescaleNormal();
		RenderSystem.enableAlphaTest();
		RenderSystem.defaultAlphaFunc();
		RenderSystem.enableBlend();
		RenderSystem.blendFunc(class_4493.class_4535.field_22541, class_4493.class_4534.field_22523);
		RenderSystem.color4f(1.0F, 1.0F, 1.0F, 1.0F);
		RenderSystem.translatef(x, y, 100.0F + client.method_1480().field_4730);
		RenderSystem.translatef(8.0F, 8.0F, 0.0F);
		RenderSystem.scalef(1.0F, -1.0F, 1.0F);
		RenderSystem.scalef(16.0F, 16.0F, 16.0F);
		class_4587 matrixStack = new class_4587();
		class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
		boolean bl = !model.method_24304();
		if (bl) {
			class_308.method_24210();
		}

		class_310.method_1551().method_1480().method_23179(stack, class_809.class_811.field_4317, false, matrixStack, immediate, 15728880, class_4608.field_21444, model);
		immediate.method_22993();
		RenderSystem.enableDepthTest();
		if (bl) {
			class_308.method_24211();
		}

		RenderSystem.disableAlphaTest();
		RenderSystem.disableRescaleNormal();
		RenderSystem.popMatrix();
		class_308.method_1450();
	}

	public static void renderGuiItemOverlay(class_4587 matrices, class_327 renderer, class_1799 stack, int x, int y,
											String countLabel, int textColor, boolean shadow) {
		class_310 client = class_310.method_1551();
		if (stack.method_7960()) {
			return;
		}

		if (stack.method_7947() != 1 || countLabel != null) {
			String string = countLabel == null ? String.valueOf(stack.method_7947()) : countLabel;
			matrices.method_22904(0.0, 0.0, client.method_1480().field_4730 + 200.0F);
			DrawUtil.drawString(matrices, string, (x + 19 - 2 - renderer.method_1727(string)), (y + 6 + 3), textColor,
				shadow);
		}

		if (stack.method_7986()) {
			RenderSystem.disableDepthTest();
			RenderSystem.disableTexture();
			RenderSystem.disableBlend();
			float f = (float) stack.method_7919();
			float g = (float) stack.method_7936();
			float h = Math.max(0.0F, (g - f) / g);
			int i = Math.round(13.0F - f * 13.0F / g);
			int j = class_3532.method_15369(h / 3.0F, 1.0F, 1.0F);
			DrawUtil.fillRect(matrices, x + 2, y + 13, 13, 2, ClientColors.BLACK.toInt());
			DrawUtil.fillRect(matrices, x + 2, y + 13, i, 1,
				(((255 << 8) + (j >> 16 & 255) << 8) + (j >> 8 & 255) << 8) + (j & 255));
			RenderSystem.enableBlend();
			RenderSystem.enableTexture();
			RenderSystem.enableDepthTest();
		}

		class_746 clientPlayerEntity = class_310.method_1551().field_1724;
		float f = clientPlayerEntity == null ? 0.0F
			: clientPlayerEntity.method_7357().method_7905(stack.method_7909(),
			class_310.method_1551().method_1488());
		if (f > 0.0F) {
			RenderSystem.disableDepthTest();
			RenderSystem.disableTexture();
			RenderSystem.enableBlend();
			RenderSystem.defaultBlendFunc();
			DrawUtil.fillRect(matrices, x, y + class_3532.method_15375(16.0F * (1.0F - f)), 16, class_3532.method_15386(16.0F * f),
				ClientColors.WHITE.withAlpha(127).toInt());
			RenderSystem.enableTexture();
			RenderSystem.enableDepthTest();
		}
	}
}
