/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.screenshotUtils;

import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;

public class DownloadImageScreen extends class_437 {
	private static final class_2960 SPRITE = new class_2960("axolotlclient", "textures/gui/sprites/go.png");

	private final class_437 parent;

	public DownloadImageScreen(class_437 parent) {
		super(new class_2588("viewScreenshot"));
		this.parent = parent;
	}

	@Override
	public void method_25394(class_4587 graphics, int mouseX, int mouseY, float delta) {
		method_25420(graphics);
		super.method_25394(graphics, mouseX, mouseY, delta);
		method_27534(graphics, field_22793, method_25440(), field_22789 / 2, 33 / 2 - field_22793.field_2000 / 2, -1);
	}

	@Override
	protected void method_25426() {
		var urlBox = new class_342(field_22793, field_22789 / 2 - 100, field_22790 / 2 - 10, 200, 20, new class_2588("pasteURL"));
		urlBox.method_1887(class_1074.method_4662("pasteURL"));
		urlBox.method_1863(s -> {
			if (s.isEmpty()) {
				urlBox.method_1887(class_1074.method_4662("pasteURL"));
			} else {
				urlBox.method_1887("");
			}
		});
		urlBox.method_1880(63);
		method_25411(urlBox);
		method_25411(new class_4185(field_22789 / 2 + 100 + 4, field_22790 / 2 - 10, 20, 20, new class_2588("download"), b -> {
			String url = urlBox.method_1882().trim();
			if (url.isEmpty()) {
				return;
			}
			//noinspection DataFlowIssue
			field_22787.method_1507(ImageScreen.create(this, ImageShare.getInstance().downloadImage(url), true));
		}) {
			@Override
			public void method_25359(class_4587 graphics, int mouseX, int mouseY, float delta) {
				class_2561 message = method_25369();
				method_25355(class_2585.field_24366);
				super.method_25359(graphics, mouseX, mouseY, delta);
				method_25355(message);
				//noinspection DataFlowIssue
				field_22787.method_1531().method_22813(SPRITE);
				method_25290(graphics, field_22760, field_22761, 0, 0, method_25368(), method_25364(), method_25368(), method_25364());
			}
		});

		method_25411(new class_4185(field_22789 / 2 - 75, field_22790 - 33 / 2 - 10, 150, 20, class_5244.field_24339, b -> method_25419()));


		method_20085(urlBox);
	}

	@Override
	public void method_25419() {
		//noinspection DataFlowIssue
		field_22787.method_1507(parent);
	}
}
