/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.screenshotUtils;

import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1159;
import net.minecraft.class_156;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;

public class LoadingImageScreen extends class_437 {

	private static final int bgColor = Colors.DARK_GRAY.toInt();
	private static final int accent = Colors.GRAY.withBrightness(0.5f).withAlpha(128).toInt();

	private final class_437 parent;
	private final CompletableFuture<Void> future;
	private final boolean freeOnClose;
	private final float loadStart = class_156.method_658();

	LoadingImageScreen(class_437 parent, CompletableFuture<Void> future, boolean freeOnClose) {
		super(new class_2588("gallery.image.loading.title"));
		this.parent = parent;
		this.future = future;
		this.freeOnClose = freeOnClose;
	}

	@Override
	public void method_25394(class_4587 graphics, int mouseX, int mouseY, float delta) {
		method_25420(graphics);
		super.method_25394(graphics, mouseX, mouseY, delta);
		method_27534(graphics, field_22793, method_25440(), field_22789 / 2, 33 / 2 - field_22793.field_2000 / 2, -1);
	}

	@Override
	protected void method_25426() {

		int buttonWidth = 75;
		int imageWidth = field_22789 - 20 - buttonWidth - 4;
		int imageHeight = field_22790 - 33 * 2;

		method_25411(new LoadingWidget(imageWidth, imageHeight)).setPosition(10, 36);
		method_25411(new LoadingWidget(buttonWidth, 20)).setPosition(10 + imageWidth + 4, 36);
		method_25411(new LoadingWidget(buttonWidth, 20)).setPosition(10 + imageWidth + 4, 36 + 20 + 4);

		method_25411(new class_4185(field_22789 / 2 - 75, field_22790 - 33 / 2 - 10, 150, 20, class_5244.field_24339, b -> method_25419()));
	}

	@Override
	public void method_25419() {
		if (freeOnClose) {
			future.cancel(false);
		}
		field_22787.method_1507(parent);
	}

	private void drawHorizontalGradient(class_4587 guiGraphics, int x1, int y1, int y2, int x2) {
		class_287 consumer = class_289.method_1348().method_1349();
		class_1159 matrix4f = guiGraphics.method_23760().method_23761();
		consumer.method_22918(matrix4f, x1, y1, 0).method_1336(bgColor >> 16 & 255, bgColor >> 8 & 255, bgColor & 255, bgColor >> 24 & 255);
		consumer.method_22918(matrix4f, x1, y2, 0).method_1336(bgColor >> 16 & 255, bgColor >> 8 & 255, bgColor & 255, bgColor >> 24 & 255);
		consumer.method_22918(matrix4f, x2, y2, 0).method_1336(accent >> 16 & 255, accent >> 8 & 255, accent & 255, accent >> 24 & 255);
		consumer.method_22918(matrix4f, x2, y1, 0).method_1336(accent >> 16 & 255, accent >> 8 & 255, accent & 255, accent >> 24 & 255);
		class_289.method_1348().method_1350();
	}

	private double easeInOutCubic(double x) {
		return x < 0.5 ? 4 * x * x * x : 1 - Math.pow(-2 * x + 2, 3) / 2;
	}

	private int lerp(float delta, int start, int end) {
		return (int) class_3532.method_15363(class_3532.method_16439(delta, start, end), start, end);
	}

	private class LoadingWidget extends class_339 {

		public LoadingWidget(int width, int height) {
			super(0, 0, width, height, class_2585.field_24366);
			field_22763 = false;
		}

		@Override
		public void method_25359(class_4587 guiGraphics, int mouseX, int mouseY, float partialTick) {
			method_25294(guiGraphics, field_22760, field_22761, field_22760 + method_25368(), field_22761 + method_25364(), bgColor);
			drawHorizontalGradient(guiGraphics, field_22760, field_22761, field_22761 + method_25364(), lerp((float) easeInOutCubic((class_156.method_658() - loadStart) % 1000f / 1000f), field_22760, field_22760 + method_25368()));
		}

		@Override
		protected class_5250 method_25360() {
			return class_2585.field_24366.method_27662();
		}

		public void setPosition(int x, int y) {
			this.field_22760 = x;
			this.field_22761 = y;
		}
	}
}
